/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.client;

import com.redhat.reportengine.client.JulReportEngineLogHandler;
import com.redhat.reportengine.client.RemoteAPI;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogHandler {
    protected static RemoteAPI remoteApi;
    protected static boolean isLoadedHandler;
    protected static JulReportEngineLogHandler reportEngineHandler;
    private static final Logger _logger;

    static {
        isLoadedHandler = false;
        reportEngineHandler = null;
        _logger = Logger.getLogger(LogHandler.class.getName());
    }

    public static void julLoggerSetup() {
        Logger logger = Logger.getLogger("");
        if (!remoteApi.getLogLevel().equalsIgnoreCase("DEFAULT")) {
            logger.setLevel(Level.parse(remoteApi.getLogLevel()));
        }
        if (isLoadedHandler) {
            logger.removeHandler(reportEngineHandler);
            logger.addHandler(reportEngineHandler);
            remoteApi.setLoggers("sun.rmi,org.apache.http,com.sun.xml.bind,com.sun.jersey", Level.WARNING);
            _logger.log(Level.INFO, "Report Engine Client: JUL Handler reloaded...");
        } else {
            reportEngineHandler = new JulReportEngineLogHandler(LogHandler.getRemoteApi());
            logger.addHandler(reportEngineHandler);
            remoteApi.setLoggers("sun.rmi,org.apache.http,com.sun.xml.bind,com.sun.jersey", Level.WARNING);
            _logger.log(Level.INFO, "Report Engine Client: JUL Handler added...");
            isLoadedHandler = true;
        }
        _logger.log(Level.INFO, "Report Engine Client: Log Level: " + logger.getLevel());
    }

    public static RemoteAPI getRemoteApi() {
        return remoteApi;
    }

    public static void setRemoteApi(RemoteAPI remoteApi) {
        LogHandler.remoteApi = remoteApi;
    }

    public static void initLogger() {
        if (remoteApi.getLoggerType().equalsIgnoreCase("JUL")) {
            LogHandler.julLoggerSetup();
        } else {
            _logger.log(Level.WARNING, "Report Engine Client: Un-supported Logger Type: " + remoteApi.getLoggerType());
        }
    }
}

