/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.server;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class MyFormatter
extends Formatter {
    public static String toString(Throwable th) {
        if (th != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            th.printStackTrace(pw);
            return sw.toString();
        }
        return null;
    }

    @Override
    public String format(LogRecord rec) {
        StringBuffer buf = new StringBuffer(1000);
        buf.append("<tr>");
        buf.append("<td>");
        if (rec.getLevel().intValue() >= Level.WARNING.intValue()) {
            buf.append("<b>");
            buf.append(rec.getLevel().getName());
            buf.append("</b>");
        } else {
            buf.append(rec.getLevel().getName());
        }
        buf.append("</td>");
        buf.append("<td>");
        buf.append(this.calcDate(rec.getMillis()));
        buf.append("</td>");
        buf.append("<td>");
        buf.append(this.formatMessage(rec));
        buf.append(", [Seq:" + rec.getSequenceNumber() + "]<BR>[Class:" + rec.getSourceClassName() + "]<BR>[Method:" + rec.getSourceMethodName() + "]<BR>[Error: " + MyFormatter.toString(rec.getThrown()));
        buf.append('\n');
        buf.append("<td>");
        buf.append("</tr>\n");
        return buf.toString();
    }

    private String calcDate(long millisecs) {
        SimpleDateFormat date_format = new SimpleDateFormat("MMM dd,yyyy HH:mm:ss.S");
        Date resultdate = new Date(millisecs);
        return date_format.format(resultdate);
    }

    @Override
    public String getHead(Handler h) {
        return "<HTML>\n<HEAD>\n" + new Date() + "\n</HEAD>\n<BODY>\n<PRE>\n" + "<table border>\n  " + "<tr><th>Level</th><th>Time</th><th>Log Message</th></tr>\n";
    }

    @Override
    public String getTail(Handler h) {
        return "</table>\n  </PRE></BODY>\n</HTML>\n";
    }
}

