/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.server;

import com.redhat.reportengine.scheduler.ManageScheduler;
import com.redhat.reportengine.server.cache.ServerSettings;
import com.redhat.reportengine.server.jobs.system.TestSuiteAggregationImpl;
import com.redhat.reportengine.server.jobs.system.UpdateJobStatus;
import com.redhat.reportengine.server.queue.actions.ManageQueues;
import com.redhat.reportengine.server.scheduler.ManageJobs;
import com.redhat.reportengine.server.sql.SqlMap;
import com.redhat.reportengine.udppacket.Collector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.log4j.Logger;

public class InitServer
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    static final Logger _logger = Logger.getLogger(InitServer.class);

    public void init() throws ServletException {
        try {
            ServerSettings.setBaseLocation((String)this.getServletContext().getRealPath("/"));
            System.out.println("Report Engine: Base Location: " + ServerSettings.getBaseLocation());
            SqlMap.setUpSqlClient();
            ServerSettings.updateSystemSettingsFromDB();
            _logger.info((Object)"Engine Settings are loaded successfully!!");
            new Thread((Runnable)new Collector(ServerSettings.getServerUdpPort(), 5120)).start();
            new Thread((Runnable)new ManageScheduler()).start();
            Thread.sleep(3000L);
            ManageJobs.loadAllJobs();
            _logger.debug((Object)"Starting Aggregation................");
            TestSuiteAggregationImpl.doAggregateTestSuite();
            _logger.debug((Object)"Completed Aggregation...............");
            _logger.debug((Object)"Starting Update Job Status...............");
            new UpdateJobStatus().execute(null);
            _logger.debug((Object)"Completed Update Job Status...............");
            ManageQueues.startAllQueueManagers();
        }
        catch (Exception ex) {
            _logger.fatal((Object)"error, ", (Throwable)ex);
        }
    }

    public void destroy() {
        _logger.info((Object)"Shutdown application command has been issued! Shutting down services (Threads)...");
        ManageScheduler.shutdown();
        Collector.stop();
        ManageQueues.stopAllQueueManagers();
        SqlMap.stopSqlMapClient();
        _logger.info((Object)"Shutdown all services (Threads) has been completed!!");
    }
}

