/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.server.ContextListener;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class ReportEngineBasicStuffInitializer
implements ServletContextListener {
    public static final String DEFAULT_CONFIG = "${user.home}/.java/reportengine";
    public static final String REPORTENGINE_CONF_LOCATION = "conf/reportengine.properties";
    private static Properties reportEngineProperies;
    public static final String REPORTENGINE_HOME_DIR = "reportengine.home.dir";
    Logger _logger = null;

    public void contextInitialized(ServletContextEvent sce) {
        if (System.getProperty(REPORTENGINE_HOME_DIR) == null) {
            String descriptorValue = sce.getServletContext().getInitParameter(REPORTENGINE_HOME_DIR);
            if (null == descriptorValue) {
                descriptorValue = DEFAULT_CONFIG;
                String[] matches = StringUtils.substringsBetween((String)descriptorValue, (String)"${", (String)"}");
                System.out.println("Value: " + descriptorValue);
                for (String match : matches) {
                    String propertyValue = System.getProperty(match);
                    String searchString = "${" + match + "}";
                    descriptorValue = StringUtils.replace((String)descriptorValue, (String)searchString, (String)propertyValue);
                }
            }
            if (!descriptorValue.endsWith("/")) {
                descriptorValue = descriptorValue + "/";
            }
            System.setProperty(REPORTENGINE_HOME_DIR, descriptorValue);
        }
        reportEngineProperies = new Properties();
        try {
            reportEngineProperies.load(new FileInputStream(System.getProperty(REPORTENGINE_HOME_DIR) + REPORTENGINE_CONF_LOCATION));
            Enumeration<Object> em = reportEngineProperies.keys();
            while (em.hasMoreElements()) {
                String key = (String)em.nextElement();
                System.setProperty(key.trim(), reportEngineProperies.getProperty(key.trim()).trim());
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.initializeLog4j();
    }

    public void initializeLog4j() {
        System.setProperty("log4j.conf.file", System.getProperty(REPORTENGINE_HOME_DIR) + System.getProperty("log4j.conf.file"));
        System.setProperty("log4j.log.file", System.getProperty(REPORTENGINE_HOME_DIR) + System.getProperty("log4j.log.file"));
        System.out.println("log4j:" + System.getProperty("log4j.conf.file"));
        System.out.println("LOG: " + System.getProperty("log4j.log.file"));
        PropertyConfigurator.configureAndWatch((String)System.getProperty("log4j.conf.file"));
        this._logger = Logger.getLogger((String)this.getClass().getName());
        this._logger.debug((Object)("log4j:" + System.getProperty("log4j.conf.file")));
        this._logger.debug((Object)("LOG: " + System.getProperty("log4j.log.file")));
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }

    public static Properties getReportEngineProperies() {
        return reportEngineProperies;
    }
}

