/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.server.reports;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class General {
    public static final String guiInputDateFormat = "dd-MM-yyyy";
    public static final String guiInputDateTimeFormat = "dd-MM-yyyy HH:mm:ss";
    public static final String dbDateFormat = "yyyy-MM-dd";
    public static final String dbDateTimeFormat = "yyyy-MM-dd HH:mm:ss.S";
    public static final String GUI_DATE_TIME = "MMM dd HH:mm:ss z yyyy";
    public static final String GUI_LOG_DATE_TIME = "MMM dd, HH:mm:ss.S z yyyy";
    public static final String GUI_TIME = "HH:mm:ss";
    public static final DecimalFormat decimalDigit2 = new DecimalFormat("#.##");
    public static final String HTML_ICONS_LOCATION = "../gui/base/icons/";
    public static final String HTML_IMAGES_LOCATION = "../gui/base/images/";
    public static final double teraSize = 1.073741824E9;
    public static final double gigaSize = 1048576.0;
    public static final double megaSize = 1024.0;

    public static String getColor(int value, boolean positive, String append) {
        StringBuffer strValue = new StringBuffer("");
        String color = "red";
        if (value == 0) {
            return strValue.append("(0").append(append).append(")").toString();
        }
        if (value > 0) {
            if (positive) {
                color = "green";
            }
        } else if (!positive) {
            color = "green";
        }
        strValue.append("<font color=\"");
        strValue.append(color);
        strValue.append("\"> (");
        if (value > 0) {
            strValue.append("+");
        }
        strValue.append(value).append(append).append(")</font>");
        return strValue.toString();
    }

    public static String getColor(int value, boolean positive) {
        return General.getColor(value, positive, "");
    }

    public static String getColorCpu(double value, boolean positive) {
        String append = "";
        StringBuffer strValue = new StringBuffer("");
        String color = "red";
        if (value == 0.0) {
            return strValue.append("(0").append(append).append(")").toString();
        }
        if (value > 0.0) {
            if (positive) {
                color = "green";
            }
        } else if (!positive) {
            color = "green";
        }
        strValue.append("<font color=\"");
        strValue.append(color);
        strValue.append("\"> (");
        if (value > 0.0) {
            strValue.append("+");
        }
        strValue.append(value).append(append).append(")</font>");
        return strValue.toString();
    }

    public static String getColorFileSizeFromBytes(long value, boolean positive) {
        StringBuffer strValue = new StringBuffer("");
        String color = "red";
        if (value == 0L) {
            return strValue.append("(0)").toString();
        }
        if (value > 0L) {
            if (positive) {
                color = "green";
            }
        } else if (!positive) {
            color = "green";
        }
        strValue.append("<font color=\"");
        strValue.append(color);
        strValue.append("\"> (");
        if (value > 0L) {
            strValue.append("+");
        } else {
            strValue.append("-");
        }
        if (value < 0L) {
            General.getFileSizeFromBytes(value * -1L);
            strValue.append(General.getFileSizeFromBytes(value * -1L)).append(")</font>");
        } else {
            strValue.append(General.getFileSizeFromBytes(value)).append(")</font>");
        }
        return strValue.toString();
    }

    public static String getGuiDateTime(Date date) {
        if (date == null) {
            return "-";
        }
        return new SimpleDateFormat(GUI_DATE_TIME).format(date);
    }

    public static String getGuiLogDateTime(Date date) {
        if (date == null) {
            return "-";
        }
        return new SimpleDateFormat(GUI_LOG_DATE_TIME).format(date);
    }

    public static String getGuiDuration(long milliseconds) {
        if (milliseconds == 0L) {
            return "-";
        }
        return General.formatIntoHHMMSS(milliseconds);
    }

    public static String formatIntoHHMMSS(long milliseconds) {
        DecimalFormat df = new DecimalFormat("00");
        int seconds = (int)(milliseconds / 1000L) % 60;
        int minutes = (int)(milliseconds / 60000L % 60L);
        int hours = (int)(milliseconds / 3600000L);
        StringBuffer duration = new StringBuffer();
        duration.append(df.format(hours)).append(":").append(df.format(minutes)).append(":").append(df.format(seconds));
        return duration.toString();
    }

    public static String getBuildDetails(String buildInfo) {
        if (buildInfo == null) {
            return "-";
        }
        if (buildInfo.length() != 0) {
            return buildInfo.split("\n")[0].trim();
        }
        return buildInfo;
    }

    public static String getHtml(String string) {
        if (string == null) {
            return "-";
        }
        return string.replace("\n", "<br>");
    }

    public static String getScreenShotIconLink(String testStatus, String screenShot) {
        StringBuffer returnData = new StringBuffer();
        if (screenShot != null) {
            String[] screen = screenShot.split("=");
            returnData.append("<a href=\"getScreenShotImage.jsp?imageId=").append(screen[1]).append("\" title=\"File Name: ").append(screen[0] + "\" class=\"ajax\">").append("<img width=\"20\" height=\"20\"  src='../images/icons/").append(testStatus).append(".png' alt='").append(testStatus).append("'>").append("</a>");
        } else {
            returnData.append("<img width=\"20\" height=\"20\"  src='../images/icons/").append(testStatus).append(".png' alt='").append(testStatus).append("'>");
        }
        return returnData.toString();
    }

    public static String getNotNullString(Object string) {
        if (string == null) {
            return "-";
        }
        return string.toString();
    }

    public static String getHourMinute(Object string) {
        if (string == null) {
            return "-";
        }
        return new SimpleDateFormat(GUI_TIME).format((Date)string);
    }

    public static String getJobFrequency(Object frequency, Object weekDays) {
        if (frequency == null) {
            return "-";
        }
        if (((String)frequency).equalsIgnoreCase("OneTime")) {
            return (String)frequency;
        }
        return frequency + " [" + weekDays + "]";
    }

    public static String getLogFileString(Object string) {
        if (string == null) {
            return "";
        }
        return string.toString();
    }

    public static String getThrowableString(String throwable) {
        if (throwable == null) {
            return "";
        }
        return throwable.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static String getLogLevelStr(String level) {
        if (level.equalsIgnoreCase("WARNING")) {
            return level.substring(0, 4);
        }
        return level;
    }

    public static boolean isCheckBoxEnabled(String status) {
        return status != null;
    }

    public static String getString(String[] args, String nextLineStr) {
        StringBuilder builder = new StringBuilder();
        if (args != null) {
            for (String arg : args) {
                builder.append(arg).append(nextLineStr);
            }
            return builder.toString();
        }
        return "-";
    }

    public static String getString(Map map, String nextLineStr) {
        StringBuilder builder = new StringBuilder();
        if (map != null) {
            Set keys = map.keySet();
            for (String key : keys) {
                builder.append(key).append("=").append(map.get(key)).append(nextLineStr);
            }
            return builder.toString();
        }
        return "-";
    }

    public static String getString(List<Object> lists, String nextLineStr) {
        StringBuilder builder = new StringBuilder();
        if (lists != null) {
            for (Object list : lists) {
                builder.append(list).append(nextLineStr);
            }
            return builder.toString();
        }
        return "-";
    }

    public static String getFileSize(long fileSize) {
        StringBuilder builder = new StringBuilder();
        if (fileSize >= 1L) {
            if ((double)fileSize > 1.073741824E9) {
                builder.append((double)Math.round((double)fileSize / 1.073741824E9 * 100.0) / 100.0);
                builder.append(" TB");
            } else if ((double)fileSize > 1048576.0) {
                builder.append((double)Math.round((double)fileSize / 1048576.0 * 100.0) / 100.0);
                builder.append(" GB");
            } else if ((double)fileSize > 1024.0) {
                builder.append((double)Math.round((double)fileSize / 1024.0 * 100.0) / 100.0);
                builder.append(" MB");
            } else {
                builder.append(fileSize);
                builder.append(" KB");
            }
        } else if (fileSize < 0L) {
            builder.append("-");
        } else {
            builder.append(fileSize);
        }
        return builder.toString();
    }

    public static String getFileSizeFromBytes(long fileSize) {
        StringBuilder builder = new StringBuilder();
        if (fileSize > 1024L) {
            if ((double)(fileSize /= 1024L) > 1.073741824E9) {
                builder.append((double)Math.round((double)fileSize / 1.073741824E9 * 100.0) / 100.0);
                builder.append(" TB");
            } else if ((double)fileSize > 1048576.0) {
                builder.append((double)Math.round((double)fileSize / 1048576.0 * 100.0) / 100.0);
                builder.append(" GB");
            } else if ((double)fileSize > 1024.0) {
                builder.append((double)Math.round((double)fileSize / 1024.0 * 100.0) / 100.0);
                builder.append(" MB");
            } else {
                builder.append(fileSize);
                builder.append(" KB");
            }
        } else if (fileSize < 0L) {
            builder.append("-");
        } else {
            builder.append(fileSize);
        }
        return builder.toString();
    }
}

