/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.server.dbdata;

import com.redhat.reportengine.server.dbmap.ResourceCpu;
import com.redhat.reportengine.server.sql.SqlMap;
import java.sql.SQLException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceCpuTable {
    public static final String CREATE_CPU_TABLE_SEQUENCE = "createCpuTableSequence";
    public static final String CREATE_CPU_TABLE = "createCpuTable";
    public static final String INSERT_CPU_USAGE = "insertCpuUsage";
    public static final String GET_CPU_USAGE = "getCpuUsage";
    public static final String GET_CPU_USAGE_BY_TIME_RANGE = "getCpuUsageByTimeRange";
    public static final String DROP_CPU_TABLE_SEQUENCE = "dropCpuTableSequence";
    public static final String DROP_CPU_TABLE = "dropCpuTable";
    public static final String CORE_CPU_TABLE_SUB_NAME = "core_cpu";
    public static final String MULTI_CPU_TABLE_SUB_NAME = "multi_cpu";

    public static String getMultiCpuSubName(int serverId, int cpuNo) {
        return "multi_cpu_" + serverId + "_" + cpuNo;
    }

    public static String getCoreCpuSubName(int serverId) {
        return "core_cpu_" + serverId;
    }

    public void createTable(String subName) throws SQLException {
        SqlMap.getSqlMapClient().insert(CREATE_CPU_TABLE_SEQUENCE, (Object)subName);
        SqlMap.getSqlMapClient().insert(CREATE_CPU_TABLE, (Object)subName);
    }

    public void add(ResourceCpu cpu) throws SQLException {
        SqlMap.getSqlMapClient().insert(INSERT_CPU_USAGE, (Object)cpu);
    }

    public ArrayList<ResourceCpu> get() throws SQLException {
        return (ArrayList)SqlMap.getSqlMapClient().queryForList(GET_CPU_USAGE);
    }

    public ArrayList<ResourceCpu> getByTimeRange(ResourceCpu resourceCpu) throws SQLException {
        return (ArrayList)SqlMap.getSqlMapClient().queryForList(GET_CPU_USAGE_BY_TIME_RANGE, (Object)resourceCpu);
    }

    public void dropTable(String subName) throws SQLException {
        SqlMap.getSqlMapClient().delete(DROP_CPU_TABLE, (Object)subName);
        SqlMap.getSqlMapClient().delete(DROP_CPU_TABLE_SEQUENCE, (Object)subName);
    }
}

