/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.server.cache;

import com.redhat.reportengine.server.dbdata.EngineSettingsTable;
import com.redhat.reportengine.server.dbmap.EngineSettings;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class ServerSettings {
    private static final Logger _logger = Logger.getLogger(ServerSettings.class);
    public static final String LOG4J_CONF_LOCATION = "log4j.conf.file";
    public static final String LOG4J_LOG_LOCATION = "log4j.log.file";
    public static final String KEY_TEST_SUITE_INACTIVE_TIME = "TestSuiteInactiveTime";
    public static final String KEY_EMAIL_SERVER = "EmailServer";
    public static final String KEY_SENDER_EMAIL = "SenderEmail";
    public static final String KEY_EMAIL_SERVER_PORT = "EmailServerPort";
    public static final String KEY_ENGINE_RMI_PORT = "EngineRMIPort";
    public static final String KEY_ENGINE_URL = "EngineURL";
    public static final String KEY_ENGINE_CURRENT_WIDGET = "EngineCurrentWidGet";
    public static final String KEY_ENGINE_AVAILABLE_WIDGETS = "EngineAvailableWidGets";
    public static final String KEY_ENGINE_CURRENT_MENU_STYLE = "EngineCurrentMenuStyle";
    public static final String KEY_ENGINE_AVAILABLE_MENU_STYLES = "EngineAvailableMenuStyles";
    private static final String log4jLocation = "WEB-INF/classes/conf/log4j.properties";
    private static final String rePropertyLocation = "WEB-INF/classes/conf/report-engine.properties";
    private static final String log4jLogLocation = "WEB-INF/logs/ReportEngine.log";
    private static final String serverTempLocation = "WEB-INF/temp";
    private static String baseLocation = "";
    private static int serverRmiPort = 9011;
    private static long testSuiteInactiveTime = 7200L;
    private static String screenShotFileLocation = "WEB-INF/temp";
    private static String emailServer = null;
    private static String emailFrom = null;
    private static String emailServerPort = null;
    private static String engineURL = null;
    private static String currentWidget = null;
    private static String availableWidgets = null;
    private static String currentMenuStyle = null;
    private static String availableMenuStyles = null;

    public static Logger getLogger() {
        return _logger;
    }

    public static String getLog4jlocation() {
        return log4jLocation;
    }

    public static String getRepropertylocation() {
        return rePropertyLocation;
    }

    public static String getLog4jloglocation() {
        return log4jLogLocation;
    }

    public static String getServertemplocation() {
        return serverTempLocation;
    }

    public static String getBaseLocation() {
        return baseLocation;
    }

    public static void setBaseLocation(String baseLocation) {
        ServerSettings.baseLocation = baseLocation;
    }

    public static int getServerRmiPort() {
        return serverRmiPort;
    }

    public static void setServerRmiPort(int serverRmiPort) {
        ServerSettings.serverRmiPort = serverRmiPort;
    }

    public static String getScreenShotFileLocation() {
        return screenShotFileLocation;
    }

    public static void setScreenShotFileLocation(String screenShotFileLocation) {
        ServerSettings.screenShotFileLocation = screenShotFileLocation;
    }

    public static long getTestSuiteInactiveTime() {
        return testSuiteInactiveTime;
    }

    public static void setTestSuiteInactiveTime(long jobInactiveTime) {
        testSuiteInactiveTime = jobInactiveTime;
    }

    public static String getEmailServer() {
        return emailServer;
    }

    public static void setEmailServer(String emailServer) {
        ServerSettings.emailServer = emailServer;
    }

    public static String getEmailFrom() {
        return emailFrom;
    }

    public static void setEmailFrom(String emailFrom) {
        ServerSettings.emailFrom = emailFrom;
    }

    public static String getEmailServerPort() {
        return emailServerPort;
    }

    public static void setEmailServerPort(String emailServerPort) {
        ServerSettings.emailServerPort = emailServerPort;
    }

    private static String getDBValue(String key) throws SQLException {
        return new EngineSettingsTable().get(key).getValue();
    }

    public static void updateSystemSettingsFromDB() throws NumberFormatException, SQLException {
        ServerSettings.setTestSuiteInactiveTime(Long.parseLong(ServerSettings.getDBValue(KEY_TEST_SUITE_INACTIVE_TIME)));
        ServerSettings.setEmailServer(ServerSettings.getDBValue(KEY_EMAIL_SERVER));
        ServerSettings.setEmailFrom(ServerSettings.getDBValue(KEY_SENDER_EMAIL));
        ServerSettings.setEmailServerPort(ServerSettings.getDBValue(KEY_EMAIL_SERVER_PORT));
        ServerSettings.setServerRmiPort(Integer.parseInt(ServerSettings.getDBValue(KEY_ENGINE_RMI_PORT)));
        ServerSettings.setEngineURL(ServerSettings.getDBValue(KEY_ENGINE_URL));
        ServerSettings.updateWidgetsSettingsFromDB();
    }

    public static void updateWidgetsSettingsFromDB() throws SQLException {
        ServerSettings.setCurrentWidget(ServerSettings.getDBValue(KEY_ENGINE_CURRENT_WIDGET));
        ServerSettings.setAvailableWidgets(ServerSettings.getDBValue(KEY_ENGINE_AVAILABLE_WIDGETS));
        ServerSettings.setCurrentMenuStyle(ServerSettings.getDBValue(KEY_ENGINE_CURRENT_MENU_STYLE));
        ServerSettings.setAvailableMenuStyles(ServerSettings.getDBValue(KEY_ENGINE_AVAILABLE_MENU_STYLES));
    }

    private static void updateSystemSettingsToDB(HttpServletRequest request, HttpSession session, String[] keys) throws SQLException {
        EngineSettings engineSettings = new EngineSettings();
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            engineSettings.setKey(key);
            engineSettings.setValue(request.getParameter(key));
            new EngineSettingsTable().modify(engineSettings);
            ++n2;
        }
    }

    public static void updateSystemSettings(HttpServletRequest request, HttpSession session) throws SQLException {
        String[] keys = new String[]{KEY_EMAIL_SERVER, KEY_EMAIL_SERVER_PORT, KEY_SENDER_EMAIL, KEY_TEST_SUITE_INACTIVE_TIME, KEY_ENGINE_RMI_PORT, KEY_ENGINE_URL};
        ServerSettings.updateSystemSettingsToDB(request, session, keys);
        ServerSettings.updateSystemSettingsFromDB();
    }

    public static void updateWidgetsSettings(HttpServletRequest request, HttpSession session) throws SQLException {
        String[] keys = new String[]{KEY_ENGINE_CURRENT_WIDGET, KEY_ENGINE_CURRENT_MENU_STYLE};
        ServerSettings.updateSystemSettingsToDB(request, session, keys);
        ServerSettings.updateWidgetsSettingsFromDB();
    }

    public static String getEngineURL() {
        return engineURL;
    }

    public static void setEngineURL(String engineURL) {
        ServerSettings.engineURL = engineURL;
    }

    public static String getCurrentWidget() {
        return currentWidget;
    }

    public static void setCurrentWidget(String currentWidget) {
        ServerSettings.currentWidget = currentWidget;
    }

    public static String getAvailableWidgets() {
        return availableWidgets;
    }

    public static void setAvailableWidgets(String availableWidgets) {
        ServerSettings.availableWidgets = availableWidgets;
    }

    public static String getCurrentMenuStyle() {
        return currentMenuStyle;
    }

    public static void setCurrentMenuStyle(String currentMenuStyle) {
        ServerSettings.currentMenuStyle = currentMenuStyle;
    }

    public static String getAvailableMenuStyles() {
        return availableMenuStyles;
    }

    public static void setAvailableMenuStyles(String availableMenuStyles) {
        ServerSettings.availableMenuStyles = availableMenuStyles;
    }
}

