/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.server.dbdata;

import com.redhat.reportengine.server.dbmap.TestCase;
import com.redhat.reportengine.server.sql.SqlMap;
import java.sql.SQLException;
import java.util.ArrayList;

public class TestCaseTable {
    private static final String INSERT_TEST_CASE = "insertTestCase";
    private static final String UPDATE_TEST_CASE_RESULT_BY_SUITE_ID = "updateTestCaseResult";
    private static final String UPDATE_TEST_CASE = "updateTestCase";
    private static final String GET_TEST_CASE_ID = "getTestCaseID";
    private static final String GET_TEST_CASES = "getTestCases";
    private static final String GET_TEST_CASES_REPORT_SUITE_ID_GROUP_ID = "getTestCasesReport";
    private static final String GET_TEST_CASES_REPORT_BY_SUITE_ID_ALL = "getTestCasesReportBySuiteIdAll";
    private static final String GET_TEST_CASES_REPORT_BY_SUITE_ID_AND_STATUS = "getTestCasesReportBySuiteIdAndStatus";
    private static final String GET_TEST_CASES_REPORT_BY_GROUP_ID_ALL = "getTestCasesReportByGroupId";
    private static final String GET_TEST_CASES_REPORT_BY_GROUP_ID_AND_STATUS = "getTestCasesReportByGroupIdAndStatus";
    private static final String GET_TEST_CASE_DETAIL_BY_TEST_CASE_ID = "getTestCaseDetailById";
    private static final String GET_TEST_CASES_SCREEN_SHOT_BY_TEST_SUITE_ID = "getTestCasesScreenShot";
    private static final String GET_TEST_CASE_LATEST_BY_SUITE_ID = "getLatestTestCaseBySuiteID";
    private static final String DELETE_TEST_CASE_BY_TEST_SUITE_ID = "deleteTestCaseByTestSuiteId";

    public void add(TestCase testCase) throws SQLException {
        SqlMap.getSqlMapClient().insert(INSERT_TEST_CASE, (Object)testCase);
    }

    public void modify(TestCase testCase) throws SQLException {
        SqlMap.getSqlMapClient().update(UPDATE_TEST_CASE, (Object)testCase);
    }

    public void modifyResult(TestCase testCase) throws SQLException {
        SqlMap.getSqlMapClient().update(UPDATE_TEST_CASE_RESULT_BY_SUITE_ID, (Object)testCase);
    }

    public TestCase getId(TestCase testCase) throws SQLException {
        return (TestCase)SqlMap.getSqlMapClient().queryForObject(GET_TEST_CASE_ID, (Object)testCase);
    }

    public ArrayList<TestCase> get(TestCase testCase) throws SQLException {
        return (ArrayList)SqlMap.getSqlMapClient().queryForList(GET_TEST_CASES, (Object)testCase);
    }

    public ArrayList<TestCase> getScreenShotBySuiteId(Integer testSuiteId) throws SQLException {
        return (ArrayList)SqlMap.getSqlMapClient().queryForList(GET_TEST_CASES_SCREEN_SHOT_BY_TEST_SUITE_ID, (Object)testSuiteId);
    }

    public ArrayList<TestCase> getDetailedAllByTestGroupIdAndTestSuiteId(TestCase testCase) throws SQLException {
        return (ArrayList)SqlMap.getSqlMapClient().queryForList(GET_TEST_CASES_REPORT_SUITE_ID_GROUP_ID, (Object)testCase);
    }

    public ArrayList<TestCase> getDetailedAllByTestSuiteId(TestCase testCase) throws SQLException {
        return (ArrayList)SqlMap.getSqlMapClient().queryForList(GET_TEST_CASES_REPORT_BY_SUITE_ID_ALL, (Object)testCase);
    }

    public ArrayList<TestCase> getDetailedAllByTestSuiteIdAndStatus(TestCase testCase) throws SQLException {
        return (ArrayList)SqlMap.getSqlMapClient().queryForList(GET_TEST_CASES_REPORT_BY_SUITE_ID_AND_STATUS, (Object)testCase);
    }

    public ArrayList<TestCase> getDetailedAllByTestGroupId(TestCase testCase) throws SQLException {
        return (ArrayList)SqlMap.getSqlMapClient().queryForList(GET_TEST_CASES_REPORT_BY_GROUP_ID_ALL, (Object)testCase);
    }

    public ArrayList<TestCase> getDetailedAllByTestGroupIdAndStatus(TestCase testCase) throws SQLException {
        return (ArrayList)SqlMap.getSqlMapClient().queryForList(GET_TEST_CASES_REPORT_BY_GROUP_ID_AND_STATUS, (Object)testCase);
    }

    public TestCase getDetailed(Integer testCaseId) throws SQLException {
        return (TestCase)SqlMap.getSqlMapClient().queryForObject(GET_TEST_CASE_DETAIL_BY_TEST_CASE_ID, (Object)testCaseId);
    }

    public TestCase getLatestByTestSuiteId(Integer testSuiteId) throws SQLException {
        return (TestCase)SqlMap.getSqlMapClient().queryForObject(GET_TEST_CASE_LATEST_BY_SUITE_ID, (Object)testSuiteId);
    }

    public void remove(int testSuiteId) throws SQLException {
        SqlMap.getSqlMapClient().delete(DELETE_TEST_CASE_BY_TEST_SUITE_ID, (Object)testSuiteId);
    }
}

