/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.server.sql;

import com.ibatis.common.resources.Resources;
import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapClientBuilder;
import java.io.Reader;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Logger;

public class SqlMap {
    private static final Logger _logger = Logger.getLogger(SqlMap.class);
    private static SqlMapClient sqlMap;

    static {
        SqlMap.initSqlMap();
    }

    private static final void initSqlMap() {
        try {
            String resource = "SqlMapConfig.xml";
            Reader reader = Resources.getResourceAsReader((String)resource);
            sqlMap = SqlMapClientBuilder.buildSqlMapClient((Reader)reader, (Properties)System.getProperties());
            _logger.info((Object)"SQL Client loaded successfully!");
        }
        catch (Exception ex) {
            _logger.error((Object)"Error", (Throwable)ex);
        }
    }

    public static void setUpSqlClient() {
        if (sqlMap == null) {
            SqlMap.initSqlMap();
        }
    }

    public static SqlMapClient getSqlMapClient() {
        return sqlMap;
    }

    public static void stopSqlMapClient() {
        try {
            Enumeration<Driver> drivers = DriverManager.getDrivers();
            while (drivers.hasMoreElements()) {
                Driver driver = drivers.nextElement();
                try {
                    DriverManager.deregisterDriver(driver);
                    _logger.info((Object)String.format("deregistering jdbc driver: %s", driver));
                }
                catch (SQLException e) {
                    _logger.info((Object)String.format("Error deregistering driver %s", driver), (Throwable)e);
                }
            }
            if (!sqlMap.getCurrentConnection().isClosed()) {
                sqlMap.endTransaction();
                sqlMap.getCurrentConnection().close();
                while (!sqlMap.getCurrentConnection().isClosed()) {
                    Thread.sleep(10L);
                }
                _logger.info((Object)"SQL MAP connection is not active!");
                return;
            }
        }
        catch (SQLException ex) {
            _logger.info((Object)"Error on SQL Map connection close!, ", (Throwable)ex);
        }
        catch (InterruptedException ex) {
            _logger.info((Object)"Error on SQL Map connection close!, ", (Throwable)ex);
        }
        _logger.info((Object)"SQL MAP connection is closed!");
    }
}

