/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.server.dbdata;

import com.redhat.reportengine.server.dbmap.AuthPermission;
import com.redhat.reportengine.server.dbmap.AuthRole;
import com.redhat.reportengine.server.dbmap.AuthRolePermissionMap;
import com.redhat.reportengine.server.sql.SqlMap;
import java.sql.SQLException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthRoleTable {
    public static final String GET_AUTH_ROLE_ALL = "getAuthRoleAll";
    public static final String GET_AUTH_ROLE_BY_NAME = "getAuthRoleByName";
    public static final String GET_AUTH_ROLE_BY_ID = "getAuthRoleById";
    public static final String INSERT_AUTH_ROLE = "insertAuthRole";
    public static final String UPDATE_AUTH_ROLE = "updateAuthRole";
    public static final String DELETE_AUTH_ROLE_BY_ID = "deleteAuthRoleById";
    public static final String INSERT_AUTH_ROLE_PERMISSION_MAP = "insertAuthRolePermissionMap";
    public static final String DELETE_AUTH_ROLE_PERMISSION_MAP_BY_ROLE_ID = "deleteAuthRolePermissionMapByRoleId";
    public static final String GET_AUTH_ROLE_PERMISSION_MAP_ALL = "getAuthRolePermissionMapAll";
    public static final String GET_AUTH_ROLE_PERMISSION_MAP_BY_ROLE_ID = "getAuthRolePermissionMapByRoleId";
    public static final String GET_AUTH_ROLE_PERMISSION_MAP_BY_PERMISSION_ID = "getAuthRolePermissionMapByPermissionId";

    public ArrayList<AuthRole> getAll() throws SQLException {
        return (ArrayList)SqlMap.getSqlMapClient().queryForList(GET_AUTH_ROLE_ALL);
    }

    public ArrayList<AuthRole> getById(AuthRole role) throws SQLException {
        return (ArrayList)SqlMap.getSqlMapClient().queryForList(GET_AUTH_ROLE_BY_ID, (Object)role);
    }

    public ArrayList<AuthRole> getByName(AuthRole role) throws SQLException {
        return (ArrayList)SqlMap.getSqlMapClient().queryForList(GET_AUTH_ROLE_BY_NAME, (Object)role);
    }

    public void add(AuthRole role) throws SQLException {
        SqlMap.getSqlMapClient().insert(INSERT_AUTH_ROLE, (Object)role);
        AuthRolePermissionMap rolePermissionMap = new AuthRolePermissionMap();
        role = (AuthRole)SqlMap.getSqlMapClient().queryForObject(GET_AUTH_ROLE_BY_NAME, (Object)role);
        rolePermissionMap.setRoleId(role.getId());
        for (AuthPermission permission : role.getPermissions()) {
            rolePermissionMap.setPermissionId(permission.getId());
            SqlMap.getSqlMapClient().insert(INSERT_AUTH_ROLE_PERMISSION_MAP, (Object)rolePermissionMap);
        }
    }

    public void update(AuthRole role) throws SQLException {
        SqlMap.getSqlMapClient().insert(UPDATE_AUTH_ROLE, (Object)role);
        AuthRolePermissionMap rolePermissionMap = new AuthRolePermissionMap();
        rolePermissionMap.setRoleId(role.getId());
        SqlMap.getSqlMapClient().delete(DELETE_AUTH_ROLE_PERMISSION_MAP_BY_ROLE_ID, (Object)rolePermissionMap);
        for (AuthPermission permission : role.getPermissions()) {
            rolePermissionMap.setPermissionId(permission.getId());
            SqlMap.getSqlMapClient().insert(INSERT_AUTH_ROLE_PERMISSION_MAP, (Object)rolePermissionMap);
        }
    }

    public void deleteById(AuthRole role) throws SQLException {
        SqlMap.getSqlMapClient().insert(DELETE_AUTH_ROLE_BY_ID, (Object)role);
    }
}

