/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.scheduler;

import com.redhat.reportengine.scheduler.JobDetails;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManageScheduler
implements Runnable {
    private static Logger _logger = Logger.getLogger(ManageScheduler.class);
    private static Scheduler scheduler = null;

    public static boolean isJobAvailable(String jobName) throws SchedulerException {
        return ManageScheduler.isJobAvailable(jobName, "DEFAULT");
    }

    public static boolean isJobAvailable(JobKey jobKey) throws SchedulerException {
        JobDetail job = scheduler.getJobDetail(jobKey);
        return job != null;
    }

    public static boolean isJobAvailable(String jobName, String groupName) throws SchedulerException {
        return ManageScheduler.isJobAvailable(new JobKey(jobName, groupName));
    }

    public static boolean removeJob(String jobName, String jobGroup) throws SchedulerException {
        return ManageScheduler.removeJob(new JobKey(jobName, jobGroup));
    }

    public static boolean removeJob(JobKey jobKey) throws SchedulerException {
        if (scheduler.deleteJob(jobKey)) {
            _logger.info((Object)("Job deleted successfully! [Job Name: " + jobKey.getName() + ", Job Group: " + jobKey.getGroup() + "]"));
            return true;
        }
        _logger.info((Object)("Unable to delete the job!, Selected Job might not be available! [Job Name: " + jobKey.getName() + ", Job Group: " + jobKey.getGroup() + "]"));
        return false;
    }

    public static Set<JobKey> getJobKeys(String jobGroupName) throws SchedulerException {
        return scheduler.getJobKeys(GroupMatcher.jobGroupEndsWith((String)jobGroupName));
    }

    public static List<String> getJobGroupNames() throws SchedulerException {
        return scheduler.getJobGroupNames();
    }

    public static boolean addJob(JobDetail job, Trigger trigger) {
        try {
            scheduler.scheduleJob(job, trigger);
            return true;
        }
        catch (SchedulerException ex) {
            _logger.error((Object)("Unable to add the job[" + job + "]"), (Throwable)ex);
            return false;
        }
    }

    public static boolean addJob(JobDetails jobDetails) {
        try {
            Trigger trigger;
            JobDetail job = jobDetails.getJobDataMap() != null ? JobBuilder.newJob(Class.forName(jobDetails.getJobTargetClass())).withIdentity(jobDetails.getName(), jobDetails.getGroup()).usingJobData(jobDetails.getJobDataMap()).build() : JobBuilder.newJob(Class.forName(jobDetails.getJobTargetClass())).withIdentity(jobDetails.getName(), jobDetails.getGroup()).build();
            if (jobDetails.getJobCronExpression() != null) {
                trigger = TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)jobDetails.getJobCronExpression())).build();
            } else {
                SimpleScheduleBuilder ssb = SimpleScheduleBuilder.simpleSchedule();
                ssb.withIntervalInMilliseconds(jobDetails.getRepeatInterval().longValue());
                if (jobDetails.getRepeatCount() != null) {
                    ssb.withRepeatCount(jobDetails.getRepeatCount().intValue());
                }
                trigger = TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)ssb).build();
            }
            if (jobDetails.getTriggerGroupName() != null) {
                trigger.getTriggerBuilder().withIdentity(jobDetails.getName(), jobDetails.getGroup());
            } else {
                trigger.getTriggerBuilder().withIdentity(jobDetails.getName(), "DEFAULT");
            }
            if (jobDetails.getJobFromTime() != null) {
                trigger.getTriggerBuilder().startAt(jobDetails.getJobFromTime());
            }
            if (jobDetails.getJobToTime() != null) {
                trigger.getTriggerBuilder().endAt(jobDetails.getJobToTime());
            }
            scheduler.scheduleJob(job, trigger);
            StringBuilder sb = new StringBuilder("New Job added Successfully!\n");
            sb.append("JobKey: ").append(job.getKey()).append("\n");
            sb.append("TargetClass: ").append(job.getJobClass().toString()).append("\n");
            if (jobDetails.getJobCronExpression() != null) {
                sb.append("Cron Expression: ").append(jobDetails.getJobCronExpression()).append("\n");
            } else {
                sb.append("Repeat Interval(milli sec): ").append(jobDetails.getRepeatInterval()).append("\n");
                if (jobDetails.getRepeatCount() != null) {
                    sb.append("Repeat Count: ").append(jobDetails.getRepeatCount()).append("\n");
                }
            }
            if (trigger.getStartTime() != null) {
                sb.append("Start Time: ").append(trigger.getStartTime()).append("\n");
            }
            if (trigger.getEndTime() != null) {
                sb.append("End Time: ").append(trigger.getEndTime()).append("\n");
            } else {
                sb.append("End Time: ").append("Never\n");
            }
            sb.append("Next Fire Time: ").append(trigger.getNextFireTime());
            _logger.info((Object)sb.toString());
            return true;
        }
        catch (SchedulerException se) {
            _logger.error((Object)"Unable to add the job!", (Throwable)se);
        }
        catch (ClassNotFoundException se) {
            _logger.error((Object)"Unable to add the job!", (Throwable)se);
        }
        return false;
    }

    public static void phaseJob(String jobName, String groupName) throws SchedulerException {
        ManageScheduler.phaseJob(new JobKey(jobName, groupName));
    }

    public static void phaseJob(JobKey jobKey) throws SchedulerException {
        scheduler.pauseJob(jobKey);
        _logger.info((Object)("Job Phased --> " + jobKey));
    }

    public static void resumeJob(String jobName, String groupName) throws SchedulerException {
        ManageScheduler.resumeJob(new JobKey(jobName, groupName));
    }

    public static void resumeJob(JobKey jobKey) throws SchedulerException {
        scheduler.resumeJob(jobKey);
        _logger.info((Object)("Job Resumed --> " + jobKey));
    }

    public static synchronized void shutdown() {
        try {
            if (scheduler != null) {
                scheduler.shutdown(true);
                if (scheduler.isShutdown()) {
                    _logger.info((Object)"Quartz Scheduler stopped...");
                } else {
                    _logger.warn((Object)"unable to stop Quartz Scheduler...");
                }
            }
        }
        catch (SchedulerException ex) {
            _logger.error((Object)"unable to stop Quartz Scheduler!", (Throwable)ex);
        }
    }

    public static synchronized void start() {
        try {
            if (scheduler == null) {
                scheduler = new StdSchedulerFactory().getScheduler();
            }
            scheduler.start();
            if (scheduler.isStarted()) {
                _logger.info((Object)"Quartz Scheduler started...");
            } else {
                _logger.warn((Object)"Unable to start Quartz Scheduler...");
            }
        }
        catch (SchedulerException ex) {
            _logger.error((Object)"unable to start Quartz Scheduler!", (Throwable)ex);
        }
    }

    @Override
    public void run() {
        ManageScheduler.start();
    }
}

