/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.agent.rest;

import com.redhat.reportengine.agent.api.AgentInfo;
import com.redhat.reportengine.agent.api.Cpu;
import com.redhat.reportengine.agent.api.Memory;
import com.redhat.reportengine.agent.api.Network;
import com.redhat.reportengine.agent.api.Pid;
import com.redhat.reportengine.agent.api.SigarUtils;
import com.redhat.reportengine.agent.rest.mapper.AgentDetails;
import com.redhat.reportengine.agent.rest.mapper.CpuInformation;
import com.redhat.reportengine.agent.rest.mapper.NetworkInfo;
import com.redhat.reportengine.agent.rest.mapper.OsDetail;
import com.redhat.reportengine.agent.rest.mapper.PidDetail;
import com.redhat.reportengine.agent.rest.mapper.UsageCpu;
import com.redhat.reportengine.agent.rest.mapper.UsageCpuMemory;
import com.redhat.reportengine.agent.rest.mapper.UsageCpus;
import com.redhat.reportengine.agent.rest.mapper.UsageMemory;
import java.util.Date;
import java.util.LinkedList;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.hyperic.sigar.DirUsage;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.OperatingSystem;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SysInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/agent")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
public class AgentResource {
    @GET
    @Path(value="/conf/agent")
    public AgentDetails getAgentSummary() {
        return AgentInfo.getAgentDetails();
    }

    @GET
    @Path(value="/conf/system")
    public SysInfo getSystemSummary() throws SigarException {
        SysInfo sysInfo = new SysInfo();
        sysInfo.gather(SigarUtils.getSigar());
        return sysInfo;
    }

    @GET
    @Path(value="/conf/os")
    public OsDetail getOperatingSystemSummary() throws SigarException {
        OsDetail osDetail = new OsDetail();
        osDetail.setOperatingSystem(OperatingSystem.getInstance());
        osDetail.setTime(new Date().getTime());
        return osDetail;
    }

    @GET
    @Path(value="/conf/cpu")
    public CpuInformation getCpu() {
        return Cpu.getCpuInfo();
    }

    @GET
    @Path(value="/conf/pid/{pid}")
    public PidDetail getPidDetail(@PathParam(value="pid") long pid) {
        return Pid.getPidDetail(pid);
    }

    @GET
    @Path(value="/list/pids")
    public LinkedList<PidDetail> getPids() {
        return Pid.getPidList();
    }

    @GET
    @Path(value="/usage/cpu")
    public UsageCpu getUsageCpu() throws SigarException {
        return Cpu.getCpuUsage();
    }

    @GET
    @Path(value="/usage/cpus")
    public UsageCpus getUsageCpus() throws SigarException {
        return Cpu.getCpusUsage();
    }

    @GET
    @Path(value="/usage/cpumemory")
    public UsageCpuMemory getUsageCpuMemory() throws SigarException {
        return Cpu.getCpuMemory();
    }

    @GET
    @Path(value="/usage/memory")
    public UsageMemory getUsageMemory() throws SigarException {
        return Memory.getMemoryUsage();
    }

    @GET
    @Path(value="/usage/swap")
    public UsageMemory getUsageSwap() throws SigarException {
        return Memory.getMemoryUsage();
    }

    @GET
    @Path(value="/conf/nw")
    public NetworkInfo getDetailNw() throws SigarException {
        return Network.getNetworkInfo();
    }

    @GET
    @Path(value="/list/nwifs")
    public String[] getListNwIfs() throws SigarException {
        return SigarUtils.getSigar().getNetInterfaceList();
    }

    @GET
    @Path(value="/conf/nwif/{ifc}")
    public NetworkInfo getDetailNwIf(@PathParam(value="ifc") String ifc) throws SigarException {
        return Network.getNetworkInfo(ifc);
    }

    @GET
    @Path(value="/list/fs")
    public FileSystem[] getListFs() throws SigarException {
        return SigarUtils.getSigar().getFileSystemList();
    }

    @GET
    @Path(value="/usage/fs/{fs}")
    public FileSystemUsage getUsageFs(@PathParam(value="fs") String fsName) throws SigarException {
        return SigarUtils.getSigar().getFileSystemUsage(fsName);
    }

    @GET
    @Path(value="/usage/dir/{dir}")
    public DirUsage getUsageDir(@PathParam(value="dir") String dirName) throws SigarException {
        return SigarUtils.getSigar().getDirUsage(dirName);
    }
}

