/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.agent.monitor.jvm;

import com.redhat.reportengine.agent.monitor.jvm.ConsoleOutputFormat;
import com.redhat.reportengine.agent.monitor.jvm.MXBeanStore;
import com.redhat.reportengine.agent.monitor.jvm.RunningJVMs;
import com.redhat.reportengine.agent.monitor.jvm.ScanVM;
import com.redhat.reportengine.agent.monitor.jvm.VMDataUtil;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Test {
    private static final Logger logger = Logger.getLogger(Test.class.getName());
    private static ConsoleOutputFormat co;
    private static String consoleVMSubSystem;
    private static int updateLimit;
    private static int updateCounter;
    private static int updateFrequency;

    public static void main(String ... args) throws InterruptedException {
        RunningJVMs.printList();
        new Timer().schedule((TimerTask)new ScanVM("AgentMain,NotBackedUp"), 500L, 5000L);
        logger.log(Level.INFO, "Searching for JVMs...");
        while (MXBeanStore.getMXBeanStoreObjectMap().isEmpty()) {
            Thread.sleep(5000L);
        }
        logger.info("Size: " + MXBeanStore.getMXBeanStoreObjectMap().size());
        logger.log(Level.INFO, "Monitoring in progress...");
        co = new ConsoleOutputFormat(consoleVMSubSystem);
        while (true) {
            String output;
            if ((output = VMDataUtil.getVMInfo()).length() > 1) {
                co.writeOutput(output);
            }
            if (updateCounter > updateLimit) break;
            ++updateCounter;
            Thread.sleep(updateFrequency);
        }
    }

    static {
        consoleVMSubSystem = "m";
        updateLimit = 720;
        updateCounter = 1;
        updateFrequency = 5000;
    }
}

