/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.agent.monitor.jvm;

import com.redhat.reportengine.agent.monitor.jvm.MXBeanStore;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.File;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class ScanVM
extends TimerTask {
    private String[] targetVMDescs = null;
    private String localVMDesc = "icom.redhat.reportengine.agent.rest.Test";
    private static final Logger logger = Logger.getLogger(ScanVM.class.getName());

    public ScanVM(String targetVMDesc) {
        this.targetVMDescs = targetVMDesc.split(",");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Lock mxBeanStoreLock = MXBeanStore.getMXBeanStoreLock();
            mxBeanStoreLock.lock();
            HashMap<String, MXBeanStore> mxBeanStoreObjectMap = MXBeanStore.getMXBeanStoreObjectMap();
            List<VirtualMachineDescriptor> vmDescriptorList = VirtualMachine.list();
            try {
                for (VirtualMachineDescriptor vmDesc : vmDescriptorList) {
                    String vmDisplayName = vmDesc.displayName();
                    for (String targetVMDesc : this.targetVMDescs) {
                        String vmId;
                        if (!vmDisplayName.contains(targetVMDesc) || vmDisplayName.contains(this.localVMDesc) || mxBeanStoreObjectMap.containsKey(vmId = vmDesc.id() + "_" + targetVMDesc)) continue;
                        MXBeanStore mxBeanStore = new MXBeanStore();
                        VirtualMachine vm = VirtualMachine.attach(vmDesc);
                        String localConnectorAddr = vm.getAgentProperties().getProperty("com.sun.management.jmxremote.localConnectorAddress");
                        if (localConnectorAddr == null) {
                            String javaHome = vm.getSystemProperties().getProperty("java.home");
                            String agentJar = javaHome + File.separator + "lib" + File.separator + "management-agent.jar";
                            vm.loadAgent(agentJar);
                            localConnectorAddr = vm.getAgentProperties().getProperty("com.sun.management.jmxremote.localConnectorAddress");
                        }
                        vm.detach();
                        JMXServiceURL serviceURL = new JMXServiceURL(localConnectorAddr);
                        JMXConnector connector = JMXConnectorFactory.connect(serviceURL);
                        MBeanServerConnection mbsc = connector.getMBeanServerConnection();
                        ObjectName osMXObject = new ObjectName("java.lang:type=OperatingSystem");
                        OperatingSystemMXBean osMXBean = ManagementFactory.newPlatformMXBeanProxy(mbsc, osMXObject.toString(), OperatingSystemMXBean.class);
                        mxBeanStore.setOSMXBean(osMXBean);
                        ObjectName memoryMXObject = new ObjectName("java.lang:type=Memory");
                        MemoryMXBean memoryMXBean = ManagementFactory.newPlatformMXBeanProxy(mbsc, memoryMXObject.toString(), MemoryMXBean.class);
                        mxBeanStore.setMemoryMXBean(memoryMXBean);
                        ObjectName classLoadingMXObject = new ObjectName("java.lang:type=ClassLoading");
                        ClassLoadingMXBean classLoadingMXBean = ManagementFactory.newPlatformMXBeanProxy(mbsc, classLoadingMXObject.toString(), ClassLoadingMXBean.class);
                        mxBeanStore.setClassLoadingMXBean(classLoadingMXBean);
                        ObjectName threadMXObject = new ObjectName("java.lang:type=Threading");
                        ThreadMXBean threadMXBean = ManagementFactory.newPlatformMXBeanProxy(mbsc, threadMXObject.toString(), ThreadMXBean.class);
                        mxBeanStore.setThreadMXBean(threadMXBean);
                        ObjectName compilationMXObject = new ObjectName("java.lang:type=Compilation");
                        CompilationMXBean compilationMXBean = ManagementFactory.newPlatformMXBeanProxy(mbsc, compilationMXObject.toString(), CompilationMXBean.class);
                        mxBeanStore.setCompilationMXBean(compilationMXBean);
                        ObjectName gcObjectNames = new ObjectName("java.lang:type=GarbageCollector,*");
                        ArrayList<GarbageCollectorMXBean> gcMXBeanList = new ArrayList<GarbageCollectorMXBean>();
                        for (ObjectName gcMXObject : mbsc.queryNames(gcObjectNames, null)) {
                            GarbageCollectorMXBean gcMXBean = ManagementFactory.newPlatformMXBeanProxy(mbsc, gcMXObject.getCanonicalName(), GarbageCollectorMXBean.class);
                            gcMXBeanList.add(gcMXBean);
                        }
                        mxBeanStore.setGCMXBean(gcMXBeanList);
                        ArrayList<MemoryPoolMXBean> memPoolMXBeanList = new ArrayList<MemoryPoolMXBean>();
                        ObjectName memPoolObjectNames = new ObjectName("java.lang:type=MemoryPool,*");
                        for (ObjectName memPoolMXObject : mbsc.queryNames(memPoolObjectNames, null)) {
                            MemoryPoolMXBean memPoolMXBean = ManagementFactory.newPlatformMXBeanProxy(mbsc, memPoolMXObject.getCanonicalName(), MemoryPoolMXBean.class);
                            memPoolMXBeanList.add(memPoolMXBean);
                        }
                        mxBeanStore.setMemPoolMXBean(memPoolMXBeanList);
                        mxBeanStoreObjectMap.put(vmId, mxBeanStore);
                    }
                }
            }
            finally {
                mxBeanStoreLock.unlock();
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.toString(), e);
        }
    }
}

