/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.agent.api;

import com.redhat.reportengine.agent.api.SigarUtils;
import com.redhat.reportengine.agent.rest.mapper.PidDetail;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.hyperic.sigar.ProcUtil;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pid {
    private static final Logger _logger = Logger.getLogger((String)Pid.class.getName());
    public static DecimalFormat df2Digit = new DecimalFormat("0.00");
    private static final String NO_SUCH_PROCESS = "No such process";

    public static LinkedList<PidDetail> getPidList() {
        LinkedList<PidDetail> pidsDetail = new LinkedList<PidDetail>();
        try {
            long[] pids;
            for (long pid : pids = SigarUtils.getSigar().getProcList()) {
                PidDetail pidBasicDetail = new PidDetail();
                pidBasicDetail.setPid(pid);
                try {
                    pidBasicDetail.setPpid(SigarUtils.getSigar().getProcState(pid).getPpid());
                }
                catch (SigarException ex) {
                    _logger.warn((Object)"Exception on ppid,", (Throwable)ex);
                    pidBasicDetail.setPpid(-1L);
                }
                try {
                    pidBasicDetail.setTty(SigarUtils.getSigar().getProcState(pid).getTty());
                }
                catch (SigarException ex) {
                    _logger.warn((Object)"Exception on tty,", (Throwable)ex);
                    pidBasicDetail.setTty(-1);
                }
                try {
                    pidBasicDetail.setStartTime(SigarUtils.getSigar().getProcTime(pid).getStartTime());
                }
                catch (SigarException ex) {
                    _logger.warn((Object)"Exception on startTime,", (Throwable)ex);
                    pidBasicDetail.setStartTime(-1L);
                }
                try {
                    pidBasicDetail.setCmd(SigarUtils.getSigar().getProcState(pid).getName());
                }
                catch (SigarException ex) {
                    _logger.warn((Object)"Exception on cmd,", (Throwable)ex);
                    pidBasicDetail.setCmd("?");
                }
                try {
                    pidBasicDetail.setUid(SigarUtils.getSigar().getProcCredName(pid).getUser());
                }
                catch (SigarException ex) {
                    _logger.warn((Object)"Exception on uid,", (Throwable)ex);
                    pidBasicDetail.setUid("?");
                }
                try {
                    pidBasicDetail.setCpu(SigarUtils.getSigar().getProcCpu(pid).getPercent());
                }
                catch (SigarException ex) {
                    _logger.warn((Object)"Exception on cpu usage,", (Throwable)ex);
                    pidBasicDetail.setCpu(-1.0);
                }
                try {
                    pidBasicDetail.setMemory(SigarUtils.getSigar().getProcMem(pid).getShare());
                }
                catch (SigarException ex) {
                    _logger.warn((Object)"Exception on memory usage,", (Throwable)ex);
                    pidBasicDetail.setMemory(-1L);
                }
                pidsDetail.addLast(pidBasicDetail);
            }
        }
        catch (SigarException ex) {
            _logger.warn((Object)"Exception on PidsList,", (Throwable)ex);
        }
        return pidsDetail;
    }

    public static PidDetail getPidDetail(long pid) {
        PidDetail pidDetail;
        block25: {
            block24: {
                pidDetail = new PidDetail();
                pidDetail.setAgentDate(new Date().getTime());
                pidDetail.setPid(pid);
                pidDetail.setAvailable(true);
                try {
                    pidDetail.setProgArgs(SigarUtils.getSigar().getProcArgs(pid));
                }
                catch (Exception ex) {
                    _logger.warn((Object)"Unable to get ProcArgs, ", (Throwable)ex);
                }
                try {
                    pidDetail.setProcCpu(SigarUtils.getSigar().getProcCpu(pid));
                }
                catch (Exception ex) {
                    _logger.warn((Object)"Unable to get ProcCpu, ", (Throwable)ex);
                    if (!ex.getMessage().contains(NO_SUCH_PROCESS)) break block24;
                    pidDetail.setAvailable(false);
                }
            }
            try {
                pidDetail.setProcCred(SigarUtils.getSigar().getProcCred(pid));
            }
            catch (Exception ex) {
                _logger.warn((Object)"Unable to get ProcCred, ", (Throwable)ex);
            }
            try {
                pidDetail.setProcCredName(SigarUtils.getSigar().getProcCredName(pid));
            }
            catch (Exception ex) {
                _logger.warn((Object)"Unable to get ProcCredName, ", (Throwable)ex);
            }
            try {
                pidDetail.setProcEnv(SigarUtils.getSigar().getProcEnv(pid));
            }
            catch (Exception ex) {
                _logger.warn((Object)"Unable to get ProcEnv, ", (Throwable)ex);
            }
            try {
                pidDetail.setProcExe(SigarUtils.getSigar().getProcExe(pid));
            }
            catch (Exception ex) {
                _logger.warn((Object)"Unable to get ProcExe, ", (Throwable)ex);
            }
            try {
                pidDetail.setProcFd(SigarUtils.getSigar().getProcFd(pid));
            }
            catch (Exception ex) {
                _logger.warn((Object)"Unable to get ProcFd, ", (Throwable)ex);
            }
            try {
                pidDetail.setProcMem(SigarUtils.getSigar().getProcMem(pid));
            }
            catch (Exception ex) {
                _logger.warn((Object)"Unable to get ProcMem, ", (Throwable)ex);
                if (!ex.getMessage().contains(NO_SUCH_PROCESS)) break block25;
                pidDetail.setAvailable(false);
            }
        }
        try {
            pidDetail.setProcModules(SigarUtils.getSigar().getProcModules(pid));
        }
        catch (Exception ex) {
            _logger.warn((Object)"Unable to get ProcModules, ", (Throwable)ex);
        }
        try {
            pidDetail.setProcState(SigarUtils.getSigar().getProcState(pid));
        }
        catch (Exception ex) {
            _logger.warn((Object)"Unable to get ProcState, ", (Throwable)ex);
        }
        try {
            pidDetail.setProcTime(SigarUtils.getSigar().getProcTime(pid));
        }
        catch (Exception ex) {
            _logger.warn((Object)"Unable to get ProcTime, ", (Throwable)ex);
        }
        try {
            pidDetail.setDescription(ProcUtil.getDescription((SigarProxy)SigarUtils.getSigar(), (long)pid));
        }
        catch (Exception ex) {
            _logger.warn((Object)"Unable to get ProcUtil.getDecription, ", (Throwable)ex);
        }
        return pidDetail;
    }
}

