/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.agent.api;

import com.redhat.reportengine.agent.api.Memory;
import com.redhat.reportengine.agent.api.SigarUtils;
import com.redhat.reportengine.agent.rest.mapper.CpuInformation;
import com.redhat.reportengine.agent.rest.mapper.UsageCpu;
import com.redhat.reportengine.agent.rest.mapper.UsageCpuMemory;
import com.redhat.reportengine.agent.rest.mapper.UsageCpus;
import java.util.Date;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.hyperic.sigar.CpuInfo;
import org.hyperic.sigar.SigarException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cpu {
    private static final Logger _logger = Logger.getLogger((String)Cpu.class.getName());

    private static void setCpuInfo(CpuInformation cpuInfo, CpuInfo cpu) {
        cpuInfo.setTime(new Date().getTime());
        cpuInfo.setCacheSize(Long.valueOf(cpu.getCacheSize()));
        cpuInfo.setCoresPerSocket(Integer.valueOf(cpu.getCoresPerSocket()));
        cpuInfo.setMhz(Integer.valueOf(cpu.getMhz()));
        cpuInfo.setTotalCores(Integer.valueOf(cpu.getTotalCores()));
        cpuInfo.setTotalSockets(Integer.valueOf(cpu.getTotalSockets()));
        cpuInfo.setVendor(cpu.getVendor());
        cpuInfo.setModel(cpu.getModel());
    }

    public static CpuInformation getCpuInfo() {
        CpuInformation cpuInfo = new CpuInformation();
        try {
            Cpu.setCpuInfo(cpuInfo, SigarUtils.getSigar().getCpuInfoList()[0]);
        }
        catch (SigarException ex) {
            _logger.error((Object)"Exception,", (Throwable)ex);
        }
        return cpuInfo;
    }

    public static LinkedList<CpuInformation> getCpuInfoAll() {
        LinkedList<CpuInformation> cpuInfos = new LinkedList<CpuInformation>();
        try {
            CpuInfo[] cpus;
            for (CpuInfo cpu : cpus = SigarUtils.getSigar().getCpuInfoList()) {
                CpuInformation cpuInfo = new CpuInformation();
                Cpu.setCpuInfo(cpuInfo, cpu);
                cpuInfos.addLast(cpuInfo);
            }
        }
        catch (SigarException se) {
            _logger.error((Object)"Error,", (Throwable)se);
        }
        return cpuInfos;
    }

    public static UsageCpus getCpusUsage() {
        UsageCpus cpus = new UsageCpus();
        try {
            cpus.setCpus(SigarUtils.getSigar().getCpuPercList());
            cpus.setCpu(SigarUtils.getSigar().getCpuPerc());
            cpus.setTime(new Date().getTime());
        }
        catch (SigarException se) {
            _logger.error((Object)"Error,", (Throwable)se);
        }
        return cpus;
    }

    public static UsageCpu getCpuUsage() {
        UsageCpu cpu = new UsageCpu();
        try {
            cpu.setCpu(SigarUtils.getSigar().getCpuPerc());
            cpu.setTime(new Date().getTime());
        }
        catch (SigarException se) {
            _logger.error((Object)"Error,", (Throwable)se);
        }
        return cpu;
    }

    public static UsageCpuMemory getCpuMemory() {
        UsageCpuMemory usageCpuMemory = new UsageCpuMemory();
        try {
            usageCpuMemory.setUsageCpus(Cpu.getCpusUsage());
            usageCpuMemory.setUsageMemory(Memory.getMemoryUsage());
            usageCpuMemory.setTime(new Date().getTime());
        }
        catch (SigarException se) {
            _logger.error((Object)"Error,", (Throwable)se);
        }
        return usageCpuMemory;
    }
}

