/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.agent;

import com.redhat.reportengine.agent.AgentProperties;
import com.redhat.reportengine.agent.rest.AgentResource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.hyperic.sigar.Sigar;
import org.jboss.resteasy.plugins.server.netty.NettyJaxrsServer;
import org.jboss.resteasy.spi.ResteasyDeployment;

public class AgentMain {
    private static Logger _logger = Logger.getLogger(AgentMain.class);
    private static String AGENT_PROPERTIES_FILE = "conf/re-agent.properties";

    public static String getSigarDetails() {
        StringBuffer sigarInfo = new StringBuffer();
        sigarInfo.append("********************** SIGAR INFO **********************").append("\n");
        sigarInfo.append("Build Date            : ").append("08/03/2012 02:04 PM").append("\n");
        sigarInfo.append("Native Build Date     : ").append(Sigar.NATIVE_BUILD_DATE).append("\n");
        sigarInfo.append("SCM Revision          : ").append("exported").append("\n");
        sigarInfo.append("Native SCM Revision   : ").append(Sigar.NATIVE_SCM_REVISION).append("\n");
        sigarInfo.append("Field Notimpl         : ").append(-1L).append("\n");
        sigarInfo.append("Version String        : ").append("1.6.5.0").append("\n");
        sigarInfo.append("Native Version String : ").append(Sigar.NATIVE_VERSION_STRING).append("\n");
        sigarInfo.append("********************************************************");
        return sigarInfo.toString();
    }

    public static void main(String[] args) {
        ResteasyDeployment deployment = new ResteasyDeployment();
        deployment.setResourceClasses(Collections.singletonList(AgentResource.class.getName()));
        NettyJaxrsServer server = new NettyJaxrsServer();
        server.setDeployment(deployment);
        try {
            AgentProperties.loadProperties(AgentProperties.getHomeLocation() + AGENT_PROPERTIES_FILE);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        server.setPort(AgentProperties.getAgentPort());
        server.start();
        _logger.info((Object)("RE-Agent is listening on port " + AgentProperties.getAgentPort()));
        _logger.info((Object)AgentMain.getSigarDetails());
    }

    static {
        Logger rootLogger = Logger.getRootLogger();
        rootLogger.setLevel(Level.DEBUG);
        rootLogger.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("[%d{ISO8601}]%5p %6.6r[%t]%x [%M(%F:%L)] %n%m%n")));
    }
}

