(ns rn-hdfs.core
  (:import [org.apache.hadoop.conf Configuration]
           [org.apache.hadoop.fs
            FileSystem
            Path])
  (:require [clojure.java.io :as io]))

(defonce *dfs-config-obj* nil)

(defonce *file-system* nil)

(defn with-config* [cnf f]
  (binding [*dfs-config-obj* (Configuration.)]
    (doseq [path (:resources cnf)]
      (.addResource *dfs-config-obj* (Path. (.getFile (io/resource path)))))
    (f)))

(defmacro with-config [cnf & body]
  `(with-config* ~cnf (fn [] ~@body)))

(defn with-hdfs-file-system* [cnf f]
  (with-config cnf
    (binding [*file-system* (FileSystem/get *dfs-config-obj*)]
      (f))))

(defmacro with-hdfs-file-system [cnf & body]
  `(with-hdfs-file-system* ~cnf
     (fn [] ~@body)))

(defn hdfs-create
  ([path]
     (hdfs-create *file-system* path))
  ([fs path]
     (.create fs (Path. path))))