(ns rpm-shared.aws.rds
  (:require [clojure.string :as string]
            [rpm-shared.aws.client :as aws.client]))

(defn rds [aws-user]
  (aws.client/client-memoized aws-user :rds))

(defn describe-snapshots
  [aws-user instance-identifier prefix type]
  (let [snapshots (aws.client/invoke (rds aws-user)
                                     {:op      :DescribeDBSnapshots
                                      :request {:SnapshotType         type
                                                :DbInstanceIdentifier instance-identifier}}
                                     :DBSnapshots)]
    (if prefix
      (filter #(string/starts-with? (:DBSnapshotIdentifier %) prefix) snapshots)
      snapshots)))

(comment
  (aws.client/doc (rds :default) :DescribeDBSnapshots)
  )

(defn create-snapshot
  [aws-user instance-identifier snapshot-name]
  (aws.client/invoke (rds aws-user)
                     {:op      :CreateDBSnapshot
                      :request {:DBInstanceIdentifier instance-identifier
                                :DBSnapshotIdentifier snapshot-name}}
                     :DBSnapshot))

(comment
  (aws.client/doc (rds :default) :CreateDBSnapshot)
  )

(defn delete-snapshot
  [aws-user snapshot]
  (aws.client/invoke (rds aws-user)
                     {:op      :DeleteDBSnapshot
                      :request {:DBSnapshotIdentifier (:DBSnapshotIdentifier snapshot)}}
                     :DBSnapshot))

(comment
  (aws.client/doc (rds :default) :DeleteDBSnapshot)
  )
