(defproject com.redpineapplemedia/rpm-shared "1.6.1"
  :description "Clojure/Script code common across RPM repos"
  :url "http://www.redpineapplemedia.com"
  :license {:name         "Eclipse Public License"
            :url          "http://www.eclipse.org/legal/epl-v10.html"
            :distribution :repo
            :comments     "Same as Clojure"}
  :global-vars
  {*warn-on-reflection* true
   *assert*             true
   ;; *unchecked-math*  :warn-on-boxed
   }

  :dependencies
  [[org.clojure/clojure "1.11.1"]
   [org.clojure/core.async "1.6.673"]
   [org.clojure/tools.logging "0.4.0"]
   [org.clojure/tools.reader "1.0.5"]
   [com.cognitect.aws/api "0.8.656"]
   [com.cognitect.aws/ec2 "845.2.1359.0"]
   [com.cognitect.aws/ec2-instance-connect "822.2.1181.0"]
   [com.cognitect.aws/ecs "845.2.1359.0"]
   [com.cognitect.aws/elasticloadbalancingv2 "836.2.1323.0"]
   [com.cognitect.aws/ecr "821.2.1107.0"]
   [com.cognitect.aws/endpoints "1.1.12.450"]
   [com.cognitect.aws/secretsmanager "845.2.1345.0"]
   [com.cognitect.aws/s3 "845.2.1359.0"]
   [com.cognitect.aws/rds "845.2.1359.0"]
   [com.taoensso/encore "3.59.0"]]

  :plugins
  [[lein-pprint "1.1.2"] ; `lein pprint`  to debug leiningen config
   [lein-ancient "0.6.10"] ; `lein ancient` to detect out-of-date deps
   ]

  :profiles
  {;; :default [:base :system :user :provided :dev]
   :test {:dependencies [[org.clojure/test.check "0.9.0"]]}
   :dev
   [:test
    {:dependencies
     [[com.clearspring.analytics/stream "2.9.5"] ; Hyperloglog, etc.
      [org.slf4j/slf4j-jdk14 "1.7.28"]
      ]}]})
