# RPM/shared-clojure

## A place to put our common Clojure/Script utils

Currently **publicly** available on [Clojars](https://clojars.org/com.redpineapplemedia/rpm-shared):

```
[com.redpineapplemedia/rpm-shared "1.6.1"] ; Stable
```

> Depending on what we end up wanting to stick in here, we *may* later want to switch to a _private_ Maven repository.

Also available via `deps.edn` (check for latest commit hash):

```
  com.redpineapplemedia/rpm-shared  {:git/url "git@bitbucket.org:redpineapplemedia/shared-clojure.git" 
                                     :sha     "fece6abaad4318e0e2b3e20a065e5aa5b79607a4"}}
```

## Intro

It happens that we sometimes have code (especially general-purpose utils, etc.) that we'd like to use across several repos.

But duplicating this code in each repo where it's used is inconvenient and error prone.

Instead, we can **write and maintain the code just once (here)**.

Benefits:

  - **Easier maintainance**: bug fixes and enhancements can be shared with a simple dependency update, etc.
  - **Increased reliability**: easier maintenance and deduplicated code (with its inevitable variations) means fewer bugs.
  - **Economies of scale**: we can spend more time optimising code when it's going to be widely used. (All consumers will benefit).

In exchange, there's some things we **need to be conscious of**:

  - **To avoid bloat**: we need to be selective about what and when things go in here.
  - **To avoid breakage**: we need to design our APIs in here carefully to **always be backward compatible** [1].

 > [1] For example: if we want to introduce breaking behaviour to a widely used fn `f`, we should instead deprecate `f` and introduce a _new_ function `g` with the new behaviour.

## Open source?

This could also be a starting point for us to experiment with the possibility of authoring **open source code**.

The kinds of habits, etc. we want to develop here for effectively developing+maintaining an internal shared library are good preparation for eventually splitting some of this stuff off into publically-released open-source.

## What's in here?

Please explore the code for an up-to-date idea. But to start:

  - A Clojure wrapper for a Java [HyperLogLog](https://en.wikipedia.org/wiki/HyperLogLog) API.
  - Some environment config utils (`get-sys-val`, `read-sys-val`, etc.)
  - Our helpers for Cognitect's [AWS client](https://github.com/cognitect-labs/aws-api)
  - More! (Please see the code)

## Adding to this library

Found a util that we're duplicating across codebases? Or have an idea for a general-purpose util that might be useful across our codebases?

Feel free to propse the addition of some code here!

## Uploading new versions to Clojars

> Feel free to ping **#engineering** for assistance, esp. the first time you do this!

  1. Remember to bump the version number in the `project.clj`, and `README.md`.

  2. `git tag` the commit that bumps the version number, and push with `git push ... --tags`

  3. **Important**: please reserve x.y.**z** minor version bumps for **strictly 100% non-breaking updates**.

  4. Because changes to this library could potentially affect multiple systems, please always ensure that _any_ (even small) code changes have undergone **rigorous review**, keeping particular mind of **potential backwards-compatibility issues**. Thanks!

  5. `lein deploy clojars` does the trick (auth details are in `vault`).
