/*
 * Decompiled with CFR 0.152.
 */
package tcms.API;

import com.redhat.qe.xmlrpc.BaseObject;
import com.redhat.qe.xmlrpc.Session;
import java.util.Map;
import org.apache.xmlrpc.XmlRpcException;
import tcms.API.TestopiaException;

public class TestRun
extends BaseObject {
    private BaseObject.IntegerAttribute planID = this.newIntegerAttribute("plan", null);
    private BaseObject.IntegerAttribute environmentID = this.newIntegerAttribute("env_id", null);
    private BaseObject.IntegerAttribute build = this.newIntegerAttribute("build", null);
    private BaseObject.IntegerAttribute manager = this.newIntegerAttribute("manager", null);
    private BaseObject.StringAttribute summary = this.newStringAttribute("summary", null);
    private BaseObject.StringAttribute notes = this.newStringAttribute("notes", null);
    private BaseObject.IntegerAttribute status = this.newIntegerAttribute("status", null);
    private BaseObject.IntegerAttribute productVersion = this.newIntegerAttribute("product_version", null);
    private BaseObject.IntegerAttribute product = this.newIntegerAttribute("product", null);

    public TestRun(Session session, Integer runID) {
        this.session = session;
        this.id = this.newIntegerAttribute("run_id", runID);
        this.listMethod = "TestRun.list";
    }

    public TestRun(Session session, Integer planID, Integer environment, Integer build, Integer manager, String summary) {
        this(session, planID, environment, build, manager, summary, null, null);
    }

    public TestRun(Session session, Integer planID, Integer environment, Integer build, Integer manager, String summary, Integer product, Integer productVersion) {
        this.session = session;
        this.planID.set(planID);
        if (environment != -1) {
            this.environmentID = this.newIntegerAttribute("env_id", environment);
        }
        this.build.set(build);
        this.manager.set(manager);
        this.summary.set(summary);
        this.listMethod = "TestRun.list";
        this.id = this.newIntegerAttribute("run_id", null);
        this.product.set(product);
        this.productVersion.set(productVersion);
    }

    public TestRun(Session session, Integer planID, Integer build, Integer manager, String summary) {
        this(session, planID, null, build, manager, summary);
    }

    public Map<String, Object> update() throws TestopiaException, XmlRpcException {
        if (this.id.get() == null) {
            throw new TestopiaException("runID is null.");
        }
        return super.updateById("TestRun.update");
    }

    public Object applyEnvironmentValue() throws XmlRpcException {
        return this.callXmlrpcMethod("TestRun.link_env_value", new Object[]{this.id.get(), this.environmentID.get()});
    }

    public Object setTags(String sTags) throws XmlRpcException {
        return this.callXmlrpcMethod("TestRun.add_tag", new Object[]{this.id.get(), sTags});
    }

    public Map<String, Object> create() throws XmlRpcException {
        return super.create("TestRun.create");
    }

    public void addCases(Integer ... cases) throws XmlRpcException {
        this.callXmlrpcMethod("TestRun.add_cases", new Object[]{this.id.get(), cases});
    }

    public Map<String, Object> getAttributes() throws TestopiaException, XmlRpcException {
        if (this.id.get() == null) {
            throw new TestopiaException("runID is null.");
        }
        return this.get("TestRun.get", new Object[]{this.id.get()});
    }

    public Object[] getTestCases() throws TestopiaException, XmlRpcException {
        if (this.id.get() == null) {
            throw new TestopiaException("runID is null.");
        }
        return (Object[])this.callXmlrpcMethod("TestRun.get_test_cases", new Object[]{this.id.get()});
    }

    public Object[] getTestCaseRuns() throws TestopiaException, XmlRpcException {
        if (this.id.get() == null) {
            throw new TestopiaException("runID is null.");
        }
        return (Object[])this.callXmlrpcMethod("TestRun.get_test_case_runs", new Object[]{this.id.get()});
    }

    public Status getStatus() {
        return this.status.get() == 1 ? Status.Running : Status.Stopped;
    }

    public void setStatus(Status status) {
        this.status.set(Integer.valueOf(status.equals((Object)Status.Running) ? 0 : 1));
    }

    public String getNotes() {
        return this.notes.get();
    }

    public void setNotes(String notes) {
        this.notes.set(notes);
    }

    public static enum Status {
        Running,
        Stopped;

    }
}

