/*
 * Decompiled with CFR 0.152.
 */
package tcms.API;

import com.redhat.qe.xmlrpc.BaseObject;
import com.redhat.qe.xmlrpc.Session;
import java.util.HashMap;
import java.util.Map;
import org.apache.xmlrpc.XmlRpcException;
import tcms.API.Product;
import tcms.API.TestopiaException;

public class Environment
extends BaseObject {
    private BaseObject.IntegerAttribute productId = this.newIntegerAttribute("product", null);
    private BaseObject.IntegerAttribute valueId = this.newIntegerAttribute("value", null);
    private BaseObject.IntegerAttribute propertyId = this.newIntegerAttribute("property", null);
    private BaseObject.StringAttribute name = this.newStringAttribute("name", null);
    private BaseObject.BooleanAttribute isactive = this.newBooleanAttribute("isactive", null);

    public Environment(Session session, Integer productId, String name) {
        this.session = session;
        this.productId.set(productId);
        this.name.set(name);
        this.id = this.newIntegerAttribute("environment_id", null);
    }

    public Environment(Session session, Integer productId, String sPropertyName, String sValueName) throws XmlRpcException {
        this.session = session;
        this.productId.set(productId);
        this.name.set(sPropertyName + ":" + sValueName);
        this.propertyId.set(Integer.valueOf(this.getEnvironmentPropertyIdByName(sPropertyName)));
        this.valueId.set(Integer.valueOf(this.getEnvironmentValueIdByName(sPropertyName, sValueName)));
    }

    public Map<String, Object> update() throws TestopiaException, XmlRpcException {
        return super.updateById("Environment.update");
    }

    public Map<String, Object> create() throws XmlRpcException {
        Map map = super.create("Environment.create");
        return map;
    }

    public HashMap<String, Object> getEnvironment(int environmentID) throws XmlRpcException {
        return (HashMap)this.callXmlrpcMethod("Environment.get", new Object[]{environmentID});
    }

    public HashMap<String, Object> listEnvironments(String productName, String environmentName) throws XmlRpcException {
        if (productName != null) {
            Product product = new Product(this.session);
            int productId = product.getProductIDByName(productName);
            if (environmentName != null) {
                return (HashMap)this.callXmlrpcMethod("Environment.get", new Object[]{productId, environmentName});
            }
            return (HashMap)this.callXmlrpcMethod("Environment.get", new Object[]{productId});
        }
        if (environmentName != null) {
            if (productName != null) {
                Product product = new Product(this.session);
                int productId = product.getProductIDByName(productName);
                return (HashMap)this.callXmlrpcMethod("Environment.get", new Object[]{productId, environmentName});
            }
            return (HashMap)this.callXmlrpcMethod("Environment.get", new Object[]{environmentName});
        }
        return null;
    }

    public HashMap<String, Object> listEnvironments(int productId, String environmentName) throws XmlRpcException {
        if (environmentName != null) {
            return (HashMap)this.callXmlrpcMethod("Environment.get", new Object[]{productId, environmentName});
        }
        return (HashMap)this.callXmlrpcMethod("Environment.get", new Object[]{productId});
    }

    public Object[] getAllEnvironmentProperties() throws XmlRpcException {
        return (Object[])this.callXmlrpcMethod("Env.get_properties", new Object[0]);
    }

    public Object[] getAllEnvironmentValues() throws XmlRpcException {
        return (Object[])this.callXmlrpcMethod("Env.get_values", new Object[0]);
    }

    public int getEnvironmentPropertyIdByName(String sPropertyName) throws XmlRpcException {
        Object[] objArray = this.getAllEnvironmentProperties();
        for (int i = 0; i < objArray.length; ++i) {
            HashMap map = (HashMap)objArray[i];
            if (!map.get("name").equals(sPropertyName)) continue;
            return (Integer)map.get("id");
        }
        throw new TestopiaException("TCMS env property(" + sPropertyName + ") not found");
    }

    public int getEnvironmentValueIdByName(String sPropertyName, String sValueName) throws XmlRpcException {
        int pId = this.getEnvironmentPropertyIdByName(sPropertyName);
        Object[] objArray = this.getAllEnvironmentValues();
        for (int i = 0; i < objArray.length; ++i) {
            HashMap map = (HashMap)objArray[i];
            if ((Integer)map.get("property_id") != pId || !map.get("value").equals(sValueName)) continue;
            return (Integer)map.get("id");
        }
        throw new TestopiaException("TCMS env property:value(" + sPropertyName + ":" + sValueName + ") not found");
    }

    public int getEnvironemntIDByName(String environmentName) throws XmlRpcException {
        this.get("Environment.check_environment", new Object[]{environmentName, this.productId.get()});
        return this.getId();
    }

    public Integer getProductId() {
        return this.productId.get();
    }

    public Integer getValueId() {
        return this.valueId.get();
    }

    public void setProductId(Integer productId) {
        this.productId.set(productId);
    }

    public String getName() {
        return this.name.get();
    }

    public void setName(String name) {
        this.name.set(name);
    }

    public Boolean getIsactive() {
        return this.isactive.get();
    }

    public void setIsactive(Boolean isactive) {
        this.isactive.set(isactive);
    }
}

