/*
 * Decompiled with CFR 0.152.
 */
package tcms.API;

import com.redhat.qe.xmlrpc.Session;
import java.util.Map;
import org.apache.xmlrpc.XmlRpcException;
import tcms.API.TestopiaException;
import tcms.API.TestopiaObject;

public class TestRun
extends TestopiaObject {
    private TestopiaObject.IntegerAttribute planID = this.newIntegerAttribute("plan", null);
    private TestopiaObject.IntegerAttribute environmentID = this.newIntegerAttribute("env_id", null);
    private TestopiaObject.IntegerAttribute build = this.newIntegerAttribute("build", null);
    private TestopiaObject.IntegerAttribute manager = this.newIntegerAttribute("manager", null);
    private TestopiaObject.StringAttribute summary = this.newStringAttribute("summary", null);
    private TestopiaObject.StringAttribute notes = this.newStringAttribute("notes", null);
    private TestopiaObject.IntegerAttribute status = this.newIntegerAttribute("status", null);
    private TestopiaObject.IntegerAttribute productVersion = this.newIntegerAttribute("product_version", null);
    private TestopiaObject.IntegerAttribute product = this.newIntegerAttribute("product", null);

    public TestRun(Session session, Integer runID) {
        this.session = session;
        this.id = this.newIntegerAttribute("run_id", runID);
        this.listMethod = "TestRun.list";
    }

    public TestRun(Session session, Integer planID, Integer environment, Integer build, Integer manager, String summary) {
        this(session, planID, environment, build, manager, summary, null, null);
    }

    public TestRun(Session session, Integer planID, Integer environment, Integer build, Integer manager, String summary, Integer product, Integer productVersion) {
        this.session = session;
        this.planID.set(planID);
        if (environment != -1) {
            this.environmentID = this.newIntegerAttribute("env_id", environment);
        }
        this.build.set(build);
        this.manager.set(manager);
        this.summary.set(summary);
        this.listMethod = "TestRun.list";
        this.id = this.newIntegerAttribute("run_id", null);
        this.product.set(product);
        this.productVersion.set(productVersion);
    }

    public TestRun(Session session, Integer planID, Integer build, Integer manager, String summary) {
        this(session, planID, null, build, manager, summary);
    }

    public Map<String, Object> update() throws TestopiaException, XmlRpcException {
        if (this.id.get() == null) {
            throw new TestopiaException("runID is null.");
        }
        return super.updateById("TestRun.update");
    }

    public Object applyEnvironmentValue() throws XmlRpcException {
        return this.callXmlrpcMethod("TestRun.link_env_value", this.id.get(), this.environmentID.get());
    }

    public Object setTags(String sTags) throws XmlRpcException {
        return this.callXmlrpcMethod("TestRun.add_tag", this.id.get(), sTags);
    }

    public Map<String, Object> create() throws XmlRpcException {
        return super.create("TestRun.create");
    }

    public void addCases(Integer ... cases) throws XmlRpcException {
        this.callXmlrpcMethod("TestRun.add_cases", this.id.get(), cases);
    }

    public Map<String, Object> getAttributes() throws TestopiaException, XmlRpcException {
        if (this.id.get() == null) {
            throw new TestopiaException("runID is null.");
        }
        return this.get("TestRun.get", this.id.get());
    }

    public Object[] getTestCases() throws TestopiaException, XmlRpcException {
        if (this.id.get() == null) {
            throw new TestopiaException("runID is null.");
        }
        return (Object[])this.callXmlrpcMethod("TestRun.get_test_cases", this.id.get());
    }

    public Object[] getTestCaseRuns() throws TestopiaException, XmlRpcException {
        if (this.id.get() == null) {
            throw new TestopiaException("runID is null.");
        }
        return (Object[])this.callXmlrpcMethod("TestRun.get_test_case_runs", this.id.get());
    }

    public Status getStatus() {
        return this.status.get() == 1 ? Status.Running : Status.Stopped;
    }

    public void setStatus(Status status) {
        this.status.set(status.equals((Object)Status.Running) ? 0 : 1);
    }

    public String getNotes() {
        return this.notes.get();
    }

    public void setNotes(String notes) {
        this.notes.set(notes);
    }

    public static enum Status {
        Running,
        Stopped;

    }
}

