/*
 * Decompiled with CFR 0.152.
 */
package tcms.API;

import com.redhat.qe.xmlrpc.Session;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.xmlrpc.XmlRpcException;
import tcms.API.TestopiaException;

public abstract class TestopiaObject {
    protected Session session;
    protected String listMethod;
    protected List<Attribute> attributes = new ArrayList<Attribute>();
    protected static Logger log = Logger.getLogger(TestopiaObject.class.getName());
    protected IntegerAttribute id;

    protected Object callXmlrpcMethod(String methodName, Object ... params) throws XmlRpcException {
        StringBuffer sb = new StringBuffer();
        for (Object param : params) {
            sb.append(param.toString());
            sb.append(param == params[params.length - 1] ? "" : ",");
        }
        log.finer("Calling xmlrpc method '" + methodName + "', with params (" + sb.toString() + ")");
        Object o = this.session.getClient().execute(methodName, params);
        log.finer("Result of '" + methodName + "' = " + TestopiaObject.deepToString(o));
        return o;
    }

    public Object[] getList(Map<String, Object> values) throws XmlRpcException {
        if (this.listMethod == null) {
            return null;
        }
        Object[] result = (Object[])this.callXmlrpcMethod(this.listMethod, values);
        return result;
    }

    public Object[] getList(String name, Object value) throws XmlRpcException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(name, value);
        return this.getList(map);
    }

    protected Map<String, Object> getDirtyAttributesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Attribute attribute : this.attributes) {
            if (attribute.getValue() == null || !attribute.isDirty()) continue;
            log.finer("Found dirty attribute: " + attribute.getName() + ", value=" + attribute.getValue());
            map.put(attribute.getName(), attribute.getValue());
        }
        return map;
    }

    protected Map<String, Object> getAttributesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Attribute attribute : this.attributes) {
            if (attribute.getValue() == null) continue;
            log.finer("Found attribute: " + attribute.getName() + ", value=" + attribute.getValue());
            map.put(attribute.getName(), attribute.getValue());
        }
        return map;
    }

    protected void syncAttributes(Map remoteMap) {
        for (Attribute attr : this.attributes) {
            String name = attr.getName();
            Object val = remoteMap.get(name);
            if (name.endsWith("_id")) {
                if (val == null) {
                    val = remoteMap.get(name.split("_id")[0]);
                }
            } else if (val == null) {
                val = remoteMap.get(name + "_id");
            }
            if (val == null) {
                try {
                    log.finer("Did not get attribute " + attr.getName() + " in response.");
                }
                catch (NullPointerException npe) {}
                continue;
            }
            attr.set(val);
            attr.clean();
        }
    }

    protected StringAttribute newStringAttribute(String name, String value) {
        StringAttribute sa = new StringAttribute(name, value);
        this.attributes.add(sa);
        return sa;
    }

    protected IntegerAttribute newIntegerAttribute(String name, Integer value) {
        IntegerAttribute ia = new IntegerAttribute(name, value);
        this.attributes.add(ia);
        return ia;
    }

    protected BooleanAttribute newBooleanAttribute(String name, Boolean value) {
        BooleanAttribute ba = new BooleanAttribute(name, value);
        this.attributes.add(ba);
        return ba;
    }

    protected void cleanAllAttributes() {
        for (Attribute attribute : this.attributes) {
            attribute.clean();
        }
    }

    protected Map<String, Object> updateById(String methodName) throws XmlRpcException {
        Map map;
        Map<String, Object> outGoingMap = this.getDirtyAttributesMap();
        if (outGoingMap.size() > 0) {
            Object o = this.callXmlrpcMethod(methodName, this.id.get(), outGoingMap);
            map = o instanceof Object[] ? (Map)((Object[])o)[0] : (Map)o;
        } else {
            throw new TestopiaException("There are no locally updated fields to update via xmlrpc!");
        }
        this.syncAttributes(map);
        return map;
    }

    protected Map<String, Object> create(String methodName) throws XmlRpcException {
        Map<String, Object> outGoingMap = this.getDirtyAttributesMap();
        if (outGoingMap.size() <= 0) {
            throw new TestopiaException("There are no locally updated fields to update via xmlrpc!");
        }
        Map map = (Map)this.callXmlrpcMethod(methodName, outGoingMap);
        this.syncAttributes(map);
        return map;
    }

    protected Map<String, Object> get(String methodName, Object ... params) throws XmlRpcException {
        Map map = (Map)this.callXmlrpcMethod(methodName, params);
        this.syncAttributes(map);
        return map;
    }

    protected Map<String, Object> getFirstMatching(String methodName, Map params) throws XmlRpcException {
        Object firstMatch = ((Object[])this.callXmlrpcMethod(methodName, params))[0];
        return (Map)firstMatch;
    }

    public Integer getId() {
        return this.id.get();
    }

    public static String deepToString(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof Object[]) {
            return Arrays.deepToString((Object[])o);
        }
        if (o instanceof Map) {
            Map m = (Map)o;
            StringBuffer b = new StringBuffer();
            b.append("{");
            for (Object key : m.keySet()) {
                b.append(TestopiaObject.deepToString(key) + ":" + TestopiaObject.deepToString(m.get(key)) + ", ");
            }
            b.append("}");
            return b.toString();
        }
        return o.toString();
    }

    public class BooleanAttribute
    extends Attribute {
        private BooleanAttribute(String name, Boolean value) {
            this.name = name;
            this.value = value;
        }

        public Boolean get() {
            return (Boolean)this.value;
        }

        public void set(Boolean s) {
            ((Attribute)this).set(s);
        }
    }

    public class IntegerAttribute
    extends Attribute {
        private IntegerAttribute(String name, Integer value) {
            this.name = name;
            this.value = value;
        }

        public Integer get() {
            return (Integer)this.value;
        }

        public void set(Integer s) {
            ((Attribute)this).set(s);
        }
    }

    public class StringAttribute
    extends Attribute {
        private StringAttribute(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String get() {
            return (String)this.value;
        }

        public void set(String s) {
            ((Attribute)this).set(s);
        }

        public String toString() {
            return (String)this.value;
        }
    }

    abstract class Attribute {
        String name = null;
        Object value = null;
        boolean dirty = true;

        Attribute() {
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void clean() {
            this.dirty = false;
        }

        public Object getValue() {
            return this.value;
        }

        private void set(Object s) {
            this.value = s;
            this.dirty = true;
        }

        public String getName() {
            return this.name;
        }
    }
}

