/*
 * Decompiled with CFR 0.152.
 */
package tcms.API;

import com.redhat.qe.xmlrpc.Session;
import java.util.HashMap;
import java.util.Map;
import org.apache.xmlrpc.XmlRpcException;
import tcms.API.TestopiaException;
import tcms.API.TestopiaObject;

public class TestCaseRun
extends TestopiaObject {
    private TestopiaObject.StringAttribute notes = this.newStringAttribute("notes", null);
    private TestopiaObject.IntegerAttribute status = this.newIntegerAttribute("case_run_status", null);
    private TestopiaObject.IntegerAttribute assigneeID = this.newIntegerAttribute("assignee", null);
    private TestopiaObject.IntegerAttribute caseID = this.newIntegerAttribute("case", null);
    private TestopiaObject.IntegerAttribute runID = this.newIntegerAttribute("run", null);
    private TestopiaObject.IntegerAttribute buildID = this.newIntegerAttribute("build", null);
    private TestopiaObject.IntegerAttribute environmentID = this.newIntegerAttribute("environment", null);
    private Map<Statuses, Integer> statuses = new HashMap<Statuses, Integer>();

    public TestCaseRun(Session session, Integer caseRunID) {
        this.session = session;
        this.id = this.newIntegerAttribute("case_run_id", caseRunID);
    }

    public TestCaseRun(Session session, int runID, int caseID, int buildID, int environmentID) {
        this.session = session;
        this.caseID.set(caseID);
        this.runID.set(runID);
        this.buildID.set(buildID);
        this.environmentID.set(environmentID);
        this.id = this.newIntegerAttribute("case_run_id", null);
    }

    public TestCaseRun(Session session, int runID, int caseID, int buildID) {
        this.session = session;
        this.caseID.set(caseID);
        this.runID.set(runID);
        this.buildID.set(buildID);
        this.id = this.newIntegerAttribute("case_run_id", null);
    }

    public Map<String, Object> update() throws TestopiaException, XmlRpcException {
        if (this.runID.get() == null) {
            throw new TestopiaException("runID is null.");
        }
        return super.updateById("TestCaseRun.update");
    }

    public Map<String, Object> create() throws XmlRpcException {
        Map<String, Object> retval = super.create("TestCaseRun.create");
        this.setRunID((Integer)retval.get("case_run_id"));
        return retval;
    }

    public Map<String, Object> getAttributes() throws XmlRpcException {
        Map m = (Map)this.callXmlrpcMethod("TestCaseRun.get", this.id);
        this.syncAttributes(m);
        return m;
    }

    public void setNotes(String notes) {
        this.notes.set(notes);
    }

    public void setStatus(Statuses status) {
        Integer iStat = this.statuses.get((Object)status);
        if (iStat == null) {
            Map map;
            try {
                map = (Map)this.callXmlrpcMethod("TestCaseRun.check_case_run_status", status.toString().toLowerCase());
            }
            catch (XmlRpcException xe) {
                throw new TestopiaException("Could not retrieve status id for " + (Object)((Object)status), xe);
            }
            iStat = (Integer)map.get("id");
            this.statuses.put(status, iStat);
        }
        this.status.set(iStat);
    }

    public void setAssigneeID(int assigneeID) {
        this.assigneeID.set(assigneeID);
    }

    public int getCaseID() {
        return this.caseID.get();
    }

    public int getRunID() {
        return this.runID.get();
    }

    public int getBuildID() {
        return this.buildID.get();
    }

    public int getEnvironmentID() {
        return this.environmentID.get();
    }

    public String getNotes() {
        return this.notes.get();
    }

    public int getAssigneeID() {
        return this.assigneeID.get();
    }

    public void setCaseID(Integer caseID) {
        this.caseID.set(caseID);
    }

    public void setRunID(Integer runID) {
        this.runID.set(runID);
    }

    public void setBuildID(Integer buildID) {
        this.buildID.set(buildID);
    }

    public void setEnvironmentID(Integer environmentID) {
        this.environmentID.set(environmentID);
    }

    public static enum Statuses {
        IDLE,
        PASSED,
        FAILED,
        RUNNING,
        PAUSED,
        BLOCKED,
        ERROR;

    }
}

