/*
 * Decompiled with CFR 0.152.
 */
package tcms.API;

import com.redhat.qe.xmlrpc.Session;
import java.util.HashMap;
import java.util.Map;
import org.apache.xmlrpc.XmlRpcException;
import tcms.API.Product;
import tcms.API.TestPlan;
import tcms.API.TestopiaException;
import tcms.API.TestopiaObject;

public class TestCase
extends TestopiaObject {
    private TestopiaObject.IntegerAttribute priority = this.newIntegerAttribute("priority", null);
    private TestopiaObject.IntegerAttribute categoryID = this.newIntegerAttribute("category", null);
    private TestopiaObject.StringAttribute arguments = this.newStringAttribute("arguments", null);
    private TestopiaObject.StringAttribute alias = this.newStringAttribute("alias", null);
    private TestopiaObject.StringAttribute requirement = this.newStringAttribute("requirement", null);
    private TestopiaObject.StringAttribute script = this.newStringAttribute("script", null);
    private TestopiaObject.IntegerAttribute caseStatusID = this.newIntegerAttribute("case_status", null);
    private TestopiaObject.StringAttribute summary = this.newStringAttribute("summary", null);
    private TestopiaObject.StringAttribute action = this.newStringAttribute("action", null);
    private TestopiaObject.StringAttribute status = this.newStringAttribute("status", null);
    private TestopiaObject.IntegerAttribute isAutomated = this.newIntegerAttribute("is_automated", null);
    private TestopiaObject.StringAttribute plan = this.newStringAttribute("plan", null);
    private TestopiaObject.IntegerAttribute productId = this.newIntegerAttribute("product", null);
    private Product prod;

    public TestCase(Session session, Integer caseID) {
        this.id = this.newIntegerAttribute("case_id", caseID);
        this.session = session;
        this.listMethod = "TestCase.list";
    }

    public TestCase(Session session, String caseAlias) throws XmlRpcException {
        this.session = session;
        this.listMethod = "TestCase.list";
        this.id = this.newIntegerAttribute("case_id", null);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("alias", caseAlias);
        this.syncAttributes(this.getFirstMatching("TestCase.filter", params));
    }

    public TestCase(Session session, String caseStatusName, Integer categoryId, String priority, String summary, Integer plan) throws XmlRpcException {
        this.session = session;
        this.caseStatusID.set(this.getStatusIdByName(caseStatusName));
        this.listMethod = "TestCase.list";
        this.categoryID.set(categoryId);
        this.priority.set(this.getPriorityIdByName(priority));
        this.summary.set(summary);
        this.plan.set(Integer.toString(plan));
        this.id = this.newIntegerAttribute("case_id", null);
    }

    public TestCase(Session session, String caseStatusName, String category, String priority, String summary, String plan, String product) throws XmlRpcException {
        this.session = session;
        this.listMethod = "TestCase.list";
        this.caseStatusID.set(this.getStatusIdByName(caseStatusName));
        this.id = this.newIntegerAttribute("case_id", null);
        this.categoryID.set(new Product(session).getCategoryIDByName(category, product));
        this.priority.set(this.getPriorityIdByName(priority));
        this.summary.set(summary);
        this.plan.set(Integer.toString(new TestPlan(session, plan).getId()));
    }

    public TestCase(Session session, String caseStatusName, String category, String priority, String summary, String plan, String product, String version) throws XmlRpcException {
        this.session = session;
        this.listMethod = "TestCase.list";
        this.caseStatusID.set(this.getStatusIdByName(caseStatusName));
        this.id = this.newIntegerAttribute("case_id", null);
        this.prod = new Product(session, product);
        this.productId.set(this.prod.getId());
        this.categoryID.set(this.prod.getCategoryIDByName(category, product));
        this.priority.set(this.getPriorityIdByName(priority));
        this.summary.set(summary);
        this.plan.set(Integer.toString(new TestPlan(session, this.prod.getId(), plan, version).getId()));
    }

    public void setAlias(String alias) {
        this.alias.set(alias);
    }

    public void setArguments(String arguments) {
        this.arguments.set(arguments);
    }

    public void setCaseStatusID(Integer caseStatusID) {
        this.caseStatusID.set(caseStatusID);
    }

    public void setCategoryID(int categoryID) {
        this.categoryID.set(categoryID);
    }

    public void setIsAutomated(Integer isAutomated) {
        this.isAutomated.set(isAutomated);
    }

    public void setPriorityID(String priorityID) throws XmlRpcException {
        this.priority.set(this.getPriorityIdByName(priorityID));
    }

    public void setRequirement(String requirement) {
        this.requirement.set(requirement);
    }

    public void setScript(String script) {
        this.script.set(script);
    }

    public void setSummary(String summary) {
        this.summary.set(summary);
    }

    public void addComponent(int componentID) throws TestopiaException, XmlRpcException {
        if (this.id.get() == null) {
            throw new TestopiaException("CaseID cannot be null");
        }
        this.callXmlrpcMethod("TestCase.add_component", this.id.get(), componentID);
    }

    public void removeComponent(int componentID) throws TestopiaException, XmlRpcException {
        if (this.id.get() == null) {
            throw new TestopiaException("CaseID cannot be null");
        }
        this.callXmlrpcMethod("TestCase.remove_component", this.id.get(), componentID);
    }

    public Object[] getComponents() throws TestopiaException, XmlRpcException {
        if (this.id.get() == null) {
            throw new TestopiaException("CaseID cannot be null");
        }
        return (Object[])this.callXmlrpcMethod("TestCase.get_components", this.id.get());
    }

    public void addTestPlan(int testPlanID) throws TestopiaException, XmlRpcException {
        if (this.id.get() == null) {
            throw new TestopiaException("CaseID cannot be null");
        }
        this.callXmlrpcMethod("TestCase.link_plan", this.id.get(), testPlanID);
    }

    public void removeTestPlan(int testPlanID) throws TestopiaException, XmlRpcException {
        if (this.id.get() == null) {
            throw new TestopiaException("CaseID cannot be null");
        }
        this.callXmlrpcMethod("TestCase.unlink_plan", this.id.get(), testPlanID);
    }

    public Object[] getTestPlans() throws TestopiaException, XmlRpcException {
        if (this.id.get() == null) {
            throw new TestopiaException("CaseID cannot be null");
        }
        return (Object[])this.callXmlrpcMethod("TestCase.get_plans", this.id.get());
    }

    public Map<String, Object> update() throws TestopiaException, XmlRpcException {
        if (this.id.get() == null) {
            throw new TestopiaException("caseID is null.");
        }
        return super.updateById("TestCase.update");
    }

    public void storeText() throws TestopiaException, XmlRpcException {
        if (this.id.get() == null) {
            throw new TestopiaException("caseID is null.");
        }
        super.callXmlrpcMethod("TestCase.store_text", this.getId(), this.getAction(), "", "", "");
    }

    public Map<String, Object> create() throws XmlRpcException {
        Map<String, Object> map = super.create("TestCase.create");
        return map;
    }

    public Map<String, Object> getAttributes() throws TestopiaException, XmlRpcException {
        if (this.id.get() == null) {
            throw new TestopiaException("caseID is null.");
        }
        return this.get("TestCase.get", this.id.get());
    }

    public int getPriorityIdByName(String priorityName) throws XmlRpcException {
        Map m = (Map)this.callXmlrpcMethod("TestCase.check_priority", priorityName);
        return (Integer)m.get("id");
    }

    public int getStatusIdByName(String caseStatusName) throws XmlRpcException {
        Map m = (Map)this.callXmlrpcMethod("TestCase.check_case_status", caseStatusName);
        return (Integer)m.get("id");
    }

    @Deprecated
    public int getBuildIDByName(String categoryName) throws XmlRpcException {
        return (Integer)this.callXmlrpcMethod("TestCase.lookup_category_id_by_name", categoryName);
    }

    public Integer getIsAutomated() {
        return this.isAutomated.get();
    }

    public Integer getPriorityID() {
        return this.priority.get();
    }

    public Integer getCategoryID() {
        return this.categoryID.get();
    }

    public String getArguments() {
        return this.arguments.get();
    }

    public String getAlias() {
        return this.alias.get();
    }

    public String getRequirement() {
        return this.requirement.get();
    }

    public String getScript() {
        return this.script.get();
    }

    public Integer getCaseStatusID() {
        return this.caseStatusID.get();
    }

    public String getSummary() {
        return this.summary.get();
    }

    public String getAction() {
        return this.action.get();
    }

    public void setAction(String action) {
        this.action.set(action);
    }

    public String getPlan() {
        return this.plan.get();
    }

    public void setPlan(Integer plans) {
        this.plan.set(Integer.toString(plans));
    }
}

