/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.auto.tcms;

import com.redhat.qe.auto.bugzilla.BlockedByBzBug;
import com.redhat.qe.auto.tcms.ImplementsNitrateTest;
import com.redhat.qe.jul.AbstractTestProcedureHandler;
import com.redhat.qe.xmlrpc.Session;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.apache.xmlrpc.XmlRpcException;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.internal.IResultListener;
import tcms.API.Build;
import tcms.API.Environment;
import tcms.API.Product;
import tcms.API.TestCase;
import tcms.API.TestCaseRun;
import tcms.API.TestPlan;
import tcms.API.TestRun;
import tcms.API.TestopiaException;
import tcms.API.User;

public class TCMSTestNGListener
implements IResultListener,
ISuiteListener {
    protected static final String TESTNG_COMPONENT_MARKER = "component-";
    protected static final String TESTNG_TESTPLAN_MARKER = "testplan-";
    protected static String TESTOPIA_PW = "";
    protected static String TESTOPIA_USER = "";
    protected static String TESTOPIA_URL = "";
    protected static String TESTOPIA_TESTRUN_TESTPLAN = "";
    protected static String TESTOPIA_TESTRUN_PRODUCT = "";
    protected static String sProcedurePreText = null;
    protected static Environment env = null;
    protected static Logger log = Logger.getLogger(TCMSTestNGListener.class.getName());
    protected TestRun testrun;
    protected Product product;
    protected Build build;
    protected TestPlan testplan;
    protected TestCase testcase;
    protected Session session;
    protected TestCaseRun testcaserun = null;
    protected static String buildName = "";
    protected static String environmentName = "";
    protected static String version = null;
    protected static boolean testcaseOverwrite = true;
    protected static String myOverwrite = null;
    protected static boolean isInUse = false;

    public static void setBuild(String buildName) {
        TCMSTestNGListener.buildName = buildName;
    }

    public static void setEnvironment(String environmentName) {
        TCMSTestNGListener.environmentName = environmentName;
    }

    public static void setVersion(String version) {
        TCMSTestNGListener.version = version;
    }

    public static void setTestcaseOverwrite(boolean overwrite) {
        testcaseOverwrite = overwrite;
    }

    public static boolean isInUse() {
        return isInUse;
    }

    public void onFinish(ISuite suite) {
    }

    public void onStart(ISuite suite) {
        isInUse = true;
    }

    public void onFinish(ITestContext context) {
        this.testrun.setStatus(TestRun.Status.Stopped);
        String notes = String.format("RESULTS: %d Passed, %d Failed, %d Skipped", context.getPassedTests().size(), context.getFailedTests().size(), context.getSkippedTests().size());
        this.testrun.setNotes(notes);
        try {
            this.testrun.update();
        }
        catch (Exception e) {
            throw new TestopiaException((Throwable)e);
        }
    }

    public void onStart(ITestContext context) {
        String testname = context.getName();
        try {
            String sTags;
            this.loginTestopia();
            this.retrieveContext();
            String sEnvironment = System.getProperty("testopia.testrun.environment");
            int iEnvID = -1;
            if (sEnvironment != null && env == null) {
                String[] saEnv = sEnvironment.split(":");
                try {
                    env = new Environment(this.session, this.product.getId(), saEnv[0], saEnv[1]);
                    iEnvID = env.getValueId();
                }
                catch (Exception e) {
                    throw new TestopiaException((Throwable)e);
                }
            }
            this.testrun = new TestRun(this.session, this.testplan.getId(), Integer.valueOf(iEnvID), this.build.getId(), this.session.getUserid(), testname, this.product.getId(), Integer.valueOf(this.product.getVersionIDByName(version)));
            this.testrun.create();
            if (iEnvID != -1) {
                this.testrun.applyEnvironmentValue();
            }
            if ((sTags = System.getProperty("testopia.testrun.tags")) != null) {
                Object result = this.testrun.setTags(sTags);
                if (result != null) {
                    System.out.println("Setting tag result: " + result.toString());
                } else {
                    System.out.println("Setting tag result: null");
                }
            }
        }
        catch (Exception e) {
            TestopiaException te = new TestopiaException("Could not create new test run in testopia.");
            te.initCause((Throwable)e);
            throw te;
        }
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
    }

    public void onTestFailure(ITestResult result) {
        this.markTestRunComplete(result);
    }

    public void onTestSkipped(ITestResult result) {
        this.markTestRunComplete(result);
    }

    protected void syncComponents(ITestResult result) {
        ArrayList<String> existingComponents = new ArrayList<String>();
        try {
            Object[] components;
            for (Object component : components = this.testcase.getComponents()) {
                String componentName = (String)((Map)component).get("name");
                existingComponents.add(componentName);
            }
        }
        catch (Exception e) {
            log.log(Level.FINER, "Unable to retrieve existing components for testcase " + this.testcase.getId() + ".", e);
        }
        List<String> newComponents = this.getComponentsFromGroupAnnotations(result);
        for (String component : newComponents) {
            if (existingComponents.contains(component)) {
                log.finer("Component is already in testcase.");
                continue;
            }
            try {
                Integer componentID = this.product.getComponentIDByName(component, TESTOPIA_TESTRUN_PRODUCT);
                this.testcase.addComponent(componentID.intValue());
            }
            catch (Exception e) {
                log.log(Level.FINER, "Unable to add component '" + component + "' in product '" + TESTOPIA_TESTRUN_PRODUCT + "' to testcase.", e);
            }
        }
        for (String component : existingComponents) {
            if (newComponents.contains(component)) continue;
            try {
                Integer componentID = this.product.getComponentIDByName(component, TESTOPIA_TESTRUN_PRODUCT);
                this.testcase.removeComponent(componentID.intValue());
            }
            catch (Exception e) {
                log.log(Level.FINER, "Unable to remove component '" + component + "' in product '" + TESTOPIA_TESTRUN_PRODUCT + "' to testcase.", e);
            }
        }
    }

    protected void syncTestPlans(ITestResult result) {
        ArrayList<Integer> existingTestPlans = new ArrayList<Integer>();
        try {
            Object[] testplans;
            for (Object testplan : testplans = this.testcase.getTestPlans()) {
                String testPlanName = (String)((Map)testplan).get("name");
                existingTestPlans.add(new TestPlan(this.session, this.product.getId(), testPlanName, version).getId());
            }
        }
        catch (Exception e) {
            log.log(Level.FINER, "Unable to retrieve associated test plans for testcase " + this.testcase.getId() + ".", e);
        }
        List<Integer> newTestPlans = this.getTestPlansFromGroupAnnotations(result);
        for (Integer testplan : newTestPlans) {
            if (existingTestPlans.contains(testplan)) {
                log.finer("Testcase is already assigned to test plan.");
                continue;
            }
            try {
                this.testcase.addTestPlan(testplan.intValue());
            }
            catch (Exception e) {
                log.log(Level.FINER, "Unable to add test plan '" + testplan + "' in product '" + TESTOPIA_TESTRUN_PRODUCT + "' to testcase.", e);
            }
        }
        for (Integer testplan : existingTestPlans) {
            if (newTestPlans.contains(testplan)) continue;
            try {
                this.testcase.removeTestPlan(testplan.intValue());
            }
            catch (Exception e) {
                log.log(Level.FINER, "Unable to remove test plan '" + testplan + "' in product '" + TESTOPIA_TESTRUN_PRODUCT + "' to testcase.", e);
            }
        }
    }

    private List<String> getComponentsFromGroupAnnotations(ITestResult result) {
        List<String> groups = Arrays.asList(result.getMethod().getGroups());
        ArrayList<String> components = new ArrayList<String>();
        for (String group : groups) {
            if (!group.startsWith(TESTNG_COMPONENT_MARKER)) continue;
            String component = group.split(TESTNG_COMPONENT_MARKER)[1];
            log.finer("Found component: " + component);
            components.add(component);
        }
        return components;
    }

    protected List<Integer> getTestPlansFromGroupAnnotations(ITestResult result) {
        List<String> groups = Arrays.asList(result.getMethod().getGroups());
        ArrayList<Integer> testplans = new ArrayList<Integer>();
        for (String group : groups) {
            if (!group.startsWith(TESTNG_TESTPLAN_MARKER)) continue;
            String testplan = group.split(TESTNG_TESTPLAN_MARKER)[1];
            log.finer("Found test plan: " + testplan);
            try {
                Integer testplanid = new TestPlan(this.session, this.product.getId(), testplan, version).getId();
                log.finer("with plan ID: " + testplanid);
                testplans.add(testplanid);
            }
            catch (Exception e) {
                log.finer("Test plan \"" + testplan + "\" not found on Testopia, skipping...");
            }
        }
        return testplans;
    }

    protected String getPackagelessTestClass(ITestResult result) {
        String pkg_class = result.getTestClass().getName();
        log.finest("Got test class of " + pkg_class);
        String[] pkgs = pkg_class.split("\\.");
        return pkgs[pkgs.length - 1];
    }

    protected TestCase getTestCaseByAnnotation(ITestResult result) {
        if (result.getMethod().getInvocationCount() > 1) {
            throw new RuntimeException("Cannot overwrite TCMS testcase from method that will be invoked multiple times: " + result.getMethod().getMethodName());
        }
        ImplementsNitrateTest annotation = result.getMethod().getMethod().getAnnotation(ImplementsNitrateTest.class);
        if (annotation == null) {
            throw new RuntimeException("No TCMS annotation present.");
        }
        return new TestCase(this.session, Integer.valueOf(annotation.caseId()));
    }

    private String cleanUpLog(String sLogText) {
        String sFinalString = "";
        String[] array = sLogText.split("<br>");
        for (int i = 0; i < array.length; ++i) {
            if (array[i].startsWith("System property automation.propertiesfile is not set") || array[i].startsWith("\nRunning against") || array[i].startsWith("\nStarting TestNG Suite") || array[i].startsWith("\nCurrent URL") || array[i].startsWith("\nStarting TestNG Script") || array[i].startsWith("\nStarting Test") || array[i].startsWith("Starting Test") || array[i].startsWith("\nTest Passed") || array[i].startsWith("\nTest Skipped") || array[i].startsWith("\nTest Failed")) continue;
            sFinalString = sFinalString.equals("") ? array[i] : sFinalString + "<br>" + array[i];
        }
        if (sFinalString.equals("\n")) {
            sFinalString = "";
        }
        return sFinalString;
    }

    public void onTestStart(ITestResult result) {
        if (sProcedurePreText == null) {
            sProcedurePreText = AbstractTestProcedureHandler.getActiveLog();
            sProcedurePreText = this.cleanUpLog(sProcedurePreText);
        }
        AbstractTestProcedureHandler.resetActiveLog();
        String sAppendParmOneToSummary = System.getProperty("testopia.testcase.appendParmOneToSummary");
        if (sAppendParmOneToSummary == null) {
            sAppendParmOneToSummary = "0";
        }
        int iteration = result.getMethod().getCurrentInvocationCount();
        log.finer("Got getCurrentInvocationCount()=" + iteration + ", total=" + result.getMethod().getInvocationCount());
        String count = "";
        String className = this.getPackagelessTestClass(result);
        if (iteration > 0) {
            count = new Integer(iteration + 1).toString();
        }
        String alias = className + "." + result.getMethod().getMethodName() + count;
        String script = className + "." + result.getMethod().getMethodName();
        String description = result.getMethod().getDescription();
        String summary = null;
        if (sAppendParmOneToSummary.equals("1") && result.getParameters() != null && result.getParameters().length > 0) {
            summary = description.length() > 0 ? description : script;
            int indexToCheck = 0;
            if (result.getParameters()[0] instanceof BlockedByBzBug) {
                indexToCheck = 1;
            }
            if (result.getParameters()[indexToCheck] instanceof String) {
                String parmOne = (String)result.getParameters()[indexToCheck];
                summary = summary + " - " + parmOne;
            } else {
                summary = description.length() > 0 ? description + count : script + count;
            }
        } else {
            summary = description.length() > 0 ? description + count : script + count;
        }
        try {
            try {
                this.testcase = this.getTestCaseByAnnotation(result);
            }
            catch (Exception e) {
                log.log(Level.FINER, "Couldn't retrieve testcase via tcms annotation, falling back to retrieving by method name.", e);
                this.testcase = new TestCase(this.session, alias);
            }
            this.testcase.setSummary(summary);
            if (result.getParameters() != null && result.getParameters().length > 0) {
                String args = Arrays.deepToString(result.getParameters());
                this.testcase.setArguments(args);
            }
            this.testcase.update();
        }
        catch (Exception e) {
            log.log(Level.FINER, "Testcase retrieval failed on '" + summary + "', probably doesn't exist yet.", e);
            try {
                log.info("Creating new testcase: " + alias);
                this.testcase = new TestCase(this.session, "PROPOSED", "--default--", "P1", summary, TESTOPIA_TESTRUN_TESTPLAN, TESTOPIA_TESTRUN_PRODUCT, version);
                this.testcase.setAlias(alias);
                this.testcase.setIsAutomated(Integer.valueOf(1));
                this.testcase.create();
            }
            catch (Exception e2) {
                throw new TestopiaException((Throwable)e2);
            }
        }
        this.syncComponents(result);
        this.syncTestPlans(result);
        log.finer("Testrun is " + this.testrun.getId());
        this.testcaserun = new TestCaseRun(this.session, this.testrun.getId().intValue(), this.testcase.getId().intValue(), this.build.getId().intValue());
        this.testcaserun.setStatus(TestCaseRun.Statuses.RUNNING);
        try {
            this.testcaserun.create();
            this.testrun.addCases(new Integer[]{this.testcaserun.getId()});
        }
        catch (Exception e) {
            throw new TestopiaException((Throwable)e);
        }
    }

    public void onTestSuccess(ITestResult result) {
        myOverwrite = System.getProperty("testopia.testcase.overwrite");
        String action = AbstractTestProcedureHandler.getActiveLog();
        action = this.cleanUpLog(action);
        action = sProcedurePreText + action;
        if (action == null) {
            action = "no procedure found!";
        }
        if (myOverwrite.equalsIgnoreCase("1")) {
            log.fine("Updating testcase " + this.testcase.getAlias() + " with successful action log: \n" + action);
            this.testcase.setAction(action);
            try {
                this.testcase.storeText();
                this.testcase.setIsAutomated(Integer.valueOf(1));
                this.testcase.update();
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Could not update testopia with successful status." + result.getName(), e);
            }
        }
        this.markTestRunComplete(result);
    }

    protected void markTestRunComplete(ITestResult result) {
        if (this.testcaserun == null) {
            return;
        }
        if (result.getStatus() == 3) {
            this.testcaserun.setStatus(TestCaseRun.Statuses.BLOCKED);
        } else {
            this.testcaserun.setNotes(AbstractTestProcedureHandler.getActiveLog());
            this.testcaserun.setStatus(result.isSuccess() ? TestCaseRun.Statuses.PASSED : TestCaseRun.Statuses.FAILED);
        }
        try {
            this.testcaserun.update();
        }
        catch (Exception e) {
            throw new TestopiaException((Throwable)e);
        }
        finally {
            AbstractTestProcedureHandler.resetActiveLog();
        }
    }

    protected String throwableToString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public void onConfigurationFailure(ITestResult result) {
    }

    public void onConfigurationSkip(ITestResult result) {
    }

    public void onConfigurationSuccess(ITestResult result) {
    }

    private static void setLogConfig() throws Exception {
        LogManager.getLogManager().readConfiguration(new FileInputStream("/home/weissj/log.properties"));
        log.info("Hello");
    }

    protected void loginTestopia() throws XmlRpcException, GeneralSecurityException, IOException {
        TESTOPIA_URL = System.getProperty("testopia.url");
        TESTOPIA_USER = System.getProperty("testopia.login");
        TESTOPIA_PW = System.getProperty("testopia.password");
        TESTOPIA_TESTRUN_PRODUCT = System.getProperty("testopia.testrun.product");
        TESTOPIA_TESTRUN_TESTPLAN = System.getProperty("testopia.testrun.testplan");
        log.finer("Logging in to testopia as " + TESTOPIA_USER);
        this.session = new Session(TESTOPIA_USER, TESTOPIA_PW, new URL(TESTOPIA_URL));
        this.session.init();
        this.session.setUserid(new User(this.session).getId());
    }

    protected void retrieveContext() throws XmlRpcException {
        this.product = new Product(this.session, System.getProperty("testopia.testrun.product"));
        this.testplan = new TestPlan(this.session, this.product.getId(), System.getProperty("testopia.testrun.testplan"), version);
        this.build = new Build(this.session, this.product.getId());
        try {
            this.build.getBuildIDByName(buildName);
        }
        catch (Exception e) {
            log.log(Level.FINER, "Couldn't find build " + buildName + ", creating new.", e);
            this.build.setName(buildName);
            this.build.create();
        }
    }

    public static void main(String[] args) throws Exception {
        LogManager.getLogManager().readConfiguration(new FileInputStream("/home/weissj/log.properties"));
        TCMSTestNGListener ttl = new TCMSTestNGListener();
        Properties p = new Properties();
        p.load(new FileInputStream("/home/weissj/automation.properties"));
        for (Object key : p.keySet()) {
            System.setProperty((String)key, p.getProperty((String)key));
        }
        ttl.loginTestopia();
        Product product = new Product(ttl.session, System.getProperty("testopia.testrun.product"));
        TestPlan testplan = new TestPlan(ttl.session, product.getId(), System.getProperty("testopia.testrun.testplan"), "2.4.0-SNAPSHOT");
        System.out.println(product.getId() + "\n" + testplan.getId());
    }

    static {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("org.apache.commons.logging.simplelog.showdatetime", "true");
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.commons.httpclient", "severe");
    }
}

