/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.auto.testng;

import com.redhat.qe.xmlrpc.Session;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.apache.xmlrpc.XmlRpcException;
import tcms.API.TestopiaObject;

public class BzChecker {
    protected static Logger log = Logger.getLogger(BzChecker.class.getName());
    protected static Bug bug;
    protected static bzState[] defaultFixedBugStates;
    protected static bzState[] fixedBugStates;
    protected static BzChecker instance;

    private BzChecker() {
    }

    private synchronized void init() {
        bug = new Bug();
        try {
            bug.connectBZ();
            String fixedStates = System.getProperty("bugzilla.fixedBugStates");
            fixedBugStates = fixedStates != null && fixedStates.length() > 0 ? this.extractStates(fixedStates) : defaultFixedBugStates;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize BzChecker.", e);
        }
    }

    public static synchronized BzChecker getInstance() {
        if (instance == null) {
            BzChecker newinst = new BzChecker();
            newinst.init();
            instance = newinst;
        }
        return instance;
    }

    public bzState getBugState(String bugId) throws XmlRpcException {
        return bzState.valueOf(this.getBugField(bugId, "bug_status").toString());
    }

    public Object getBugField(String bugId, String fieldId) throws XmlRpcException {
        return bug.getBug(bugId).get(fieldId);
    }

    public void setBugState(String bugId, bzState state) {
        try {
            bug.update_bug_status(bugId, state);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not set bug status " + bugId + " in bugzilla.", e);
        }
    }

    public void login(String userid, String password) {
        try {
            bug.login(userid, password);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not log in to bugzilla as " + userid, e);
        }
    }

    public void addComment(String bugId, String comment) {
        try {
            bug.add_bug_comment(bugId, comment);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not add comment to bug " + bugId, e);
        }
    }

    public void addKeywords(String bugId, String ... keywords) {
        this.editKeywords(bugId, true, keywords);
    }

    public void deleteKeywords(String bugId, String ... keywords) {
        this.editKeywords(bugId, true, keywords);
    }

    protected void editKeywords(String bugId, boolean add, String ... keywords) {
        try {
            HashMap<String, Object> updates = new HashMap<String, Object>();
            updates.put(add ? "add_keyword" : "delete_keyword", keywords);
            bug.update_bug(bugId, updates);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not " + (add ? "add" : "remove") + " keywords for bug " + bugId, e);
        }
    }

    public boolean isBugOpen(String bugId) throws XmlRpcException {
        bzState state = this.getBugState(bugId);
        for (bzState fixedBugState : fixedBugStates) {
            if (!state.equals((Object)fixedBugState)) continue;
            return false;
        }
        return true;
    }

    protected bzState[] extractStates(String states) {
        String[] splits = states.split(",");
        ArrayList<bzState> list = new ArrayList<bzState>();
        for (String state : splits) {
            list.add(bzState.valueOf(state.trim().toUpperCase()));
        }
        return list.toArray(new bzState[0]);
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("org.apache", "debug");
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.commons.httpclient", "debug");
        try {
            LogManager.getLogManager().readConfiguration(new FileInputStream("/home/jweiss/log.properties"));
        }
        catch (Exception e) {
            System.err.println("Unable to read log config file.");
        }
        Properties p = new Properties();
        p.load(new FileInputStream("/home/jweiss/automation.properties"));
        for (Object key : p.keySet()) {
            System.setProperty((String)key, p.getProperty((String)key));
        }
        log.info("connecting to " + p.getProperty("bugzilla.url"));
        log.info("Starting");
        BzChecker checker = BzChecker.getInstance();
        log.info("initialized.");
        log.info("Keywords: " + checker.getBugField("470058", "keywords"));
        log.info("" + (Object)((Object)checker.getBugState("571833")));
    }

    static {
        defaultFixedBugStates = new bzState[]{bzState.ON_QA, bzState.VERIFIED, bzState.RELEASE_PENDING, bzState.POST, bzState.CLOSED};
        instance = null;
    }

    public class Bug
    extends TestopiaObject {
        private String BZ_URL;
        private Map<String, Object> buglist;

        public Bug() {
            this.listMethod = "Bug.get_bugs";
            this.buglist = new HashMap<String, Object>();
        }

        protected void connectBZ() throws XmlRpcException, GeneralSecurityException, IOException {
            this.BZ_URL = System.getProperty("bugzilla.url");
            this.session = new Session(System.getProperty("bugzilla.login"), System.getProperty("bugzilla.password"), new URL(this.BZ_URL));
            this.session.init();
            this.login(System.getProperty("bugzilla.login"), System.getProperty("bugzilla.password"));
        }

        public int login(String userid, String password) throws XmlRpcException {
            HashMap<String, String> main = new HashMap<String, String>();
            main.put("login", userid);
            main.put("password", password);
            Map map = (Map)this.callXmlrpcMethod("User.login", new Object[]{main});
            return (Integer)map.get("id");
        }

        public Map<String, Object> getBug(String bugId) throws XmlRpcException {
            Object bug = null;
            if (System.getProperty("bugzilla.cache", "false").equals("true")) {
                log.info("Cache hit");
                bug = this.buglist.get(bugId);
            }
            if (bug == null) {
                bug = this.callXmlrpcMethod("bugzilla.getBug", new Object[]{bugId});
                this.buglist.put(bugId, bug);
            }
            return (Map)bug;
        }

        public Object[] getBugs(Map<String, Object> values) throws XmlRpcException {
            if (this.listMethod == null) {
                return null;
            }
            Map map = (Map)this.callXmlrpcMethod(this.listMethod, new Object[]{values});
            return (Object[])map.get("bugs");
        }

        public Object[] getBugs(String name, Object value) throws XmlRpcException {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(name, value);
            return this.getBugs(map);
        }

        public Map update_bug_status(String bug_id, bzState newState) throws XmlRpcException {
            HashMap<String, Object> updates = new HashMap<String, Object>();
            updates.put("bug_status", newState.toString());
            return this.update_bug(bug_id, updates);
        }

        protected Map update_bug(String bug_id, Map<String, Object> updates) throws XmlRpcException {
            HashMap<String, Object> main = new HashMap<String, Object>();
            main.put("updates", updates);
            main.put("ids", Integer.parseInt(bug_id));
            Map map = (Map)this.callXmlrpcMethod("Bug.update", new Object[]{main});
            return map;
        }

        public Map add_bug_comment(String bug_id, String comment) throws XmlRpcException {
            HashMap<String, Object> main = new HashMap<String, Object>();
            main.put("id", Integer.parseInt(bug_id));
            main.put("comment", comment);
            Map map = (Map)this.callXmlrpcMethod("Bug.add_comment", new Object[]{main});
            return map;
        }
    }

    public static enum bzState {
        NEW,
        ASSIGNED,
        MODIFIED,
        ON_DEV,
        ON_QA,
        VERIFIED,
        FAILS_QA,
        RELEASE_PENDING,
        POST,
        CLOSED;

    }
}

