/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.cli;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloCliDataProvider;
import com.redhat.qe.katello.base.KatelloCliTestScript;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.base.obj.KatelloPermission;
import com.redhat.qe.katello.base.obj.KatelloUserRole;
import com.redhat.qe.katello.common.KatelloUtils;
import com.redhat.qe.tools.SSHCommandResult;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class PermissionTests
extends KatelloCliTestScript {
    private String organization;
    private String usr_role;

    @BeforeClass(description="init: create org stuff", groups={"headpin-cli"})
    public void setUp() {
        String uid = KatelloUtils.getUniqueID();
        this.organization = "permorg-" + uid;
        KatelloOrg org = new KatelloOrg(this.organization, null);
        SSHCommandResult res = org.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.usr_role = "perm-role-" + uid;
        KatelloUserRole perm_role = new KatelloUserRole(this.usr_role, null);
        res = perm_role.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
    }

    @Test(description="create Permissions", groups={"headpin-cli"}, dataProvider="permission_create", dataProviderClass=KatelloCliDataProvider.class, enabled=true)
    public void testPerm_create(String name, String scope, String tags, String verbs, String user_role, Integer exitCode, String output) {
        KatelloPermission perm = new KatelloPermission(name, this.organization, scope, tags, verbs, user_role);
        SSHCommandResult res = perm.create();
        Assert.assertTrue((res.getExitCode().intValue() == exitCode.intValue() ? 1 : 0) != 0, (String)"Check - return code");
        if (exitCode == 0) {
            Assert.assertTrue((boolean)this.getOutput(res).contains(output), (String)"Check - returned output string");
        } else {
            Assert.assertTrue((boolean)this.getOutput(res).contains(output), (String)"Check - returned error string");
        }
    }

    @Test(description="list available scopes, verbs and tags that can be set in a permission", groups={"headpin-cli"}, dataProvider="permission_available_verbs", dataProviderClass=KatelloCliDataProvider.class, enabled=true)
    public void testPerm_available_verbs(String scope, Integer exitCode) {
        KatelloPermission perm = new KatelloPermission(null, this.organization, scope, null, null, null);
        SSHCommandResult res = perm.available_verbs(this.organization, scope);
        Assert.assertTrue((res.getExitCode().intValue() == exitCode.intValue() ? 1 : 0) != 0, (String)"Check - return code");
    }

    @Test(description="delete a permission", groups={"headpin-cli"}, enabled=true)
    public void test_delete_permission() {
        String verbs;
        String scope;
        String uid = KatelloUtils.getUniqueID();
        String permName = "perm-delete-" + uid;
        KatelloPermission perm_del = new KatelloPermission(permName, this.organization, scope = "environments", null, verbs = "update_systems,read_contents,read_systems,register_systems,delete_systems", this.usr_role);
        SSHCommandResult res = perm_del.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (permission create)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully created permission [ %s ] for user role [ %s ]", permName, this.usr_role)), (String)"Check - returned output string (permission create)");
        res = perm_del.list();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (permission list)");
        res = perm_del.delete();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (permission delete)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully deleted permission [ %s ] for role [ %s ]", permName, this.usr_role)), (String)"Check - returned output string (permission delete)");
        res = perm_del.list();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (permission list)");
    }
}

