/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.base.obj;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloCliTestScript;
import com.redhat.qe.katello.base.obj._KatelloObject;
import com.redhat.qe.tools.SSHCommandResult;
import javax.management.Attribute;

public class KatelloUser
extends _KatelloObject {
    public static final String DEFAULT_ADMIN_USER = "admin";
    public static final String DEFAULT_ADMIN_PASS = "admin";
    public static final String DEFAULT_USER_PASS = "testing";
    public static final String DEFAULT_USER_EMAIL = "root@localhost";
    public static final String CMD_CREATE = "user create";
    public static final String CLI_CMD_INFO = "user info";
    public static final String CLI_CMD_LIST = "user list";
    public static final String CMD_ASSIGN_ROLE = "user assign_role";
    public static final String CMD_DELETE_USER = "user delete";
    public static final String CMD_UNASSIGN_ROLE = "user unassign_role";
    public static final String CMD_LIST_ROLES = "user list_roles";
    public static final String CMD_REPORT = "user report";
    public static final String OUT_CREATE = "Successfully created user [ %s ]";
    public static final String OUT_DELETE = "Successfully deleted user [ %s ]";
    public static final String OUT_ASSIGN_ROLE = "User '%s' assigned to role '%s'";
    public static final String OUT_UNASSIGN_ROLE = "User '%s' unassigned from role '%s'";
    public static final String OUT_FIND_USER_ERROR = "Could not find user '%s'";
    public static final String REG_USER_LIST = ".*Id\\s*:\\s*\\d+.*Username\\s*:\\s*%s.*Email\\s*:\\s*%s.*";
    public static final String REG_USER_ROLE_LIST = ".*\\d+\\s*%s.*";
    public static final String API_CMD_INFO = "/users/%s";
    public static final String API_CMD_LIST = "/users";
    public static final String API_CMD_CREATE = "/users";
    public String username;
    public String email;
    public String password;
    public boolean disabled;
    public String orgname = "";
    public String envname = "";
    private Long id;

    public KatelloUser() {
    }

    public KatelloUser(String pName, String pEmail, String pPassword, boolean pDisabled) {
        this.username = pName;
        this.email = pEmail;
        this.password = pPassword;
        this.disabled = pDisabled;
    }

    public KatelloUser(String pName, String pEmail, String pPassword, boolean pDisabled, String pOrgname, String pEnvname) {
        this(pName, pEmail, pPassword, pDisabled);
        this.orgname = pOrgname;
        this.envname = pEnvname;
    }

    public KatelloUser(String pName, String pEmail, String pPassword, boolean pDisabled, String pOrgname, String pEnvname, Long id) {
        this(pName, pEmail, pPassword, pDisabled, pOrgname, pEnvname);
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public SSHCommandResult report(String format) {
        this.opts.clear();
        if (!format.isEmpty()) {
            this.opts.add(new Attribute("format", format));
        }
        return this.run(CMD_REPORT);
    }

    public SSHCommandResult cli_create() {
        this.opts.clear();
        this.opts.add(new Attribute("username", this.username));
        this.opts.add(new Attribute("password", this.password));
        this.opts.add(new Attribute("email", this.email));
        if (this.disabled) {
            this.opts.add(new Attribute("disabled", "true"));
        }
        if (!this.orgname.isEmpty()) {
            this.opts.add(new Attribute("default_organization", this.orgname));
        }
        if (!this.envname.isEmpty()) {
            this.opts.add(new Attribute("default_environment", this.envname));
        }
        return this.run(CMD_CREATE);
    }

    public SSHCommandResult cli_info() {
        this.opts.clear();
        this.opts.add(new Attribute("username", this.username));
        return this.run(CLI_CMD_INFO);
    }

    public SSHCommandResult cli_list() {
        this.opts.clear();
        return this.run("user list -v");
    }

    public SSHCommandResult assign_role(String role) {
        this.opts.clear();
        this.opts.add(new Attribute("username", this.username));
        this.opts.add(new Attribute("role", role));
        return this.run(CMD_ASSIGN_ROLE);
    }

    public SSHCommandResult unassign_role(String role) {
        this.opts.clear();
        this.opts.add(new Attribute("username", this.username));
        this.opts.add(new Attribute("role", role));
        return this.run(CMD_UNASSIGN_ROLE);
    }

    public SSHCommandResult list_roles() {
        this.opts.clear();
        this.opts.add(new Attribute("username", this.username));
        return this.run(CMD_LIST_ROLES);
    }

    public SSHCommandResult delete() {
        this.opts.clear();
        this.opts.add(new Attribute("username", this.username));
        return this.run(CMD_DELETE_USER);
    }

    public void asserts_delete() {
        SSHCommandResult res = this.cli_list();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (user list)");
    }

    public void asserts_create() {
        SSHCommandResult res = this.cli_list();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (user list)");
        String REGEXP_LIST = ".*Id\\s*:\\s*\\d+.*Username\\s*:\\s*%s.*Email\\s*:\\s*%s.*Disabled\\s*:\\s*False.*Default Organization\\s*:\\s*%s.*Default Environment\\s*:\\s*%s.*";
        if (this.disabled) {
            REGEXP_LIST = ".*Id\\s*:\\s*\\d+.*Username\\s*:\\s*%s.*Email\\s*:\\s*%s.*Disabled\\s*:\\s*True.*Default Organization\\s*:\\s*%s.*Default Environment\\s*:\\s*%s.*";
        }
        String match_info = String.format(REGEXP_LIST, this.username, this.email, this.orgname != null ? this.orgname : "None", this.envname != null ? this.envname : "None").replaceAll("\"", "");
        Assert.assertTrue((boolean)KatelloCliTestScript.sgetOutput(res).replaceAll("\n", "").matches(match_info), (String)String.format("User [%s] should be found in the list", this.username));
        res = this.cli_info();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (user info)");
        String REGEXP_INFO = ".*Id\\s*:\\s*\\d+.*Username\\s*:\\s*%s.*Email\\s*:\\s*%s.*Disabled\\s*:\\s*False.*Default Organization\\s*:\\s*%s.*Default Environment\\s*:\\s*%s.*";
        if (this.disabled) {
            REGEXP_INFO = ".*Id\\s*:\\s*\\d+.*Username\\s*:\\s*%s.*Email\\s*:\\s*%s.*Disabled\\s*:\\s*True.*Default Organization\\s*:\\s*%s.*Default Environment\\s*:\\s*%s.*";
        }
        match_info = String.format(REGEXP_INFO, this.username, this.email, this.orgname != null ? this.orgname : "None", this.envname != null ? this.envname : "None").replaceAll("\"", "");
        Assert.assertTrue((boolean)KatelloCliTestScript.sgetOutput(res).replaceAll("\n", "").matches(match_info), (String)String.format("User [%s] should contain correct info", this.username));
    }
}

