/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.base.obj;

import com.redhat.qe.katello.base.obj._KatelloObject;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.logging.Logger;
import javax.management.Attribute;
import org.codehaus.jackson.annotate.JsonProperty;

public class KatelloOrg
extends _KatelloObject {
    protected static Logger log = Logger.getLogger(KatelloOrg.class.getName());
    public static final String DEFAULT_ORG = "ACME_Corporation";
    public static final String CLI_CMD_CREATE = "org create";
    public static final String CLI_CMD_INFO = "org info";
    public static final String CLI_CMD_LIST = "org list";
    public static final String CMD_SUBSCRIPTIONS = "org subscriptions";
    public static final String CMD_UEBERCERT = "org uebercert";
    public static final String CMD_DELETE = "org delete";
    public static final String CMD_UPDATE = "org update";
    public static final String API_CMD_INFO = "/organizations/%s";
    public static final String OUT_CREATE = "Successfully created org [ %s ]";
    public static final String ERR_ORG_EXISTS = "Validation failed: Name has already been taken, Label has already been taken";
    public static final String ERR_NAME_INVALID = "Validation failed: Name cannot contain characters other than alpha numerals, space,'_', '-'.";
    public static final String ERR_ORG_NOTFOUND = "Couldn't find organization '%s'";
    public static final String REG_ORG_LIST = ".*Id\\s*:\\s+\\d+.*Name\\s*:\\s+%s.*Description\\s*:\\s+%s.*";
    public static final String REG_ORG_INFO = ".*Id\\s*:\\s+\\d+.*Name\\s*:\\s+%s.*Description\\s*:\\s+%s.*";
    public static final String OUT_ORG_SUBSCR = ".*Subscription\\s*:\\s*%s.*";
    public String name;
    public String description;
    public String label;
    private Long id;
    private String cpKey;

    public KatelloOrg() {
    }

    public KatelloOrg(String pName, String pDesc) {
        this.name = pName;
        this.description = pDesc;
    }

    protected KatelloOrg(Long id, String name, String description) {
        this(name, description);
        this.id = id;
    }

    public KatelloOrg(String name, String description, String label) {
        this(name, description);
        this.label = label;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="cp_key")
    public String getCpKey() {
        return this.cpKey;
    }

    @JsonProperty(value="cp_key")
    public void setCpKey(String cpKey) {
        this.cpKey = cpKey;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public SSHCommandResult cli_create() {
        this.opts.clear();
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("description", this.description));
        this.opts.add(new Attribute("label", this.label));
        return this.run(CLI_CMD_CREATE);
    }

    public SSHCommandResult cli_info() {
        this.opts.clear();
        this.opts.add(new Attribute("name", this.name));
        return this.run(CLI_CMD_INFO);
    }

    public SSHCommandResult cli_list() {
        this.opts.clear();
        return this.run("org list -v");
    }

    public SSHCommandResult subscriptions() {
        this.opts.clear();
        this.opts.add(new Attribute("name", this.name));
        return this.run(CMD_SUBSCRIPTIONS);
    }

    public SSHCommandResult uebercert() {
        this.opts.clear();
        this.opts.add(new Attribute("name", this.name));
        return this.run(CMD_UEBERCERT);
    }

    public SSHCommandResult delete() {
        this.opts.clear();
        this.opts.add(new Attribute("name", this.name));
        return this.run(CMD_DELETE);
    }

    public SSHCommandResult update(String new_description) {
        this.opts.clear();
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("description", new_description));
        return this.run(CMD_UPDATE);
    }
}

