/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.base.obj;

import com.redhat.qe.katello.base.obj._KatelloObject;
import com.redhat.qe.tools.SSHCommandResult;
import javax.management.Attribute;

public class KatelloTemplate
extends _KatelloObject {
    public static final String CMD_CREATE = "template create";
    public static final String CMD_DELETE = "template delete";
    public static final String CMD_LIST = "template list";
    public static final String CMD_INFO = "template info -v";
    public static final String CMD_UPDATE = "template update";
    public static final String CMD_EXPORT = "template export";
    public static final String FORMAT_TDL = "tdl";
    public static final String ERR_TEMPL_NOTFOUND = "Could not find template [ %s ] within environment [ %s ]";
    public static final String REG_TEMPL_INFO = ".*Id\\s*:\\s+\\d+.*Name\\s*:\\s+%s.*Revision\\s*:\\s+%s.*Description\\s*:\\s+%s.*Parent Id\\s*:\\s+%s.*";
    public static final String REG_TEMPL_PARAMS = ".*Parameters\\s*:\\s+.*%s\\s*:\\s+%s.*";
    public static final String REG_TEMPL_PACKAGES = ".*Packages\\s*:\\s+.*%s.*";
    public static final String REG_TEMPL_PACKAGEGROUPS = ".*Package Groups\\s*:\\s+.*%s.*";
    public static final String REG_TEMPL_REPOS = ".*Repositories\\s*:\\s+.*%s.*";
    public static final String REG_TEMPL_LIST = ".*\\s+\\d+.*\\s+%s.*\\s+%s.*\\s+%s.*";
    public static final String REG_TEMPL_ID = "Id:\\s+\\d+.*Name\\s*:";
    public static final String OUT_CREATE = "Successfully created template [ %s ]";
    public static final String OUT_UPDATE = "Successfully updated template [ %s ]";
    public String name;
    public String org;
    public String description;
    public String parent;
    public String parentId;
    public String revision;

    public KatelloTemplate(String pName, String pDesc, String pOrg, String pParent) {
        this.name = pName;
        this.description = pDesc;
        this.org = pOrg;
        this.parent = pParent;
    }

    public SSHCommandResult create() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("description", this.description));
        this.opts.add(new Attribute("parent", this.parent));
        return this.run(CMD_CREATE);
    }

    public SSHCommandResult info(String environment) {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("environment", environment));
        return this.run(CMD_INFO);
    }

    public SSHCommandResult delete() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        return this.run(CMD_DELETE);
    }

    public SSHCommandResult list() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        return this.run(CMD_LIST);
    }

    public SSHCommandResult update_add_distribution(String product, String distribution) {
        this.opts.clear();
        this.opts.add(new Attribute("from_product", product));
        this.opts.add(new Attribute("add_distribution", distribution));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        return this.run(CMD_UPDATE);
    }

    public SSHCommandResult update_add_repo(String product, String repo) {
        this.opts.clear();
        this.opts.add(new Attribute("from_product", product));
        this.opts.add(new Attribute("add_repository", repo));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        return this.run(CMD_UPDATE);
    }

    public SSHCommandResult update_remove_repo(String product, String repo) {
        this.opts.clear();
        this.opts.add(new Attribute("from_product", product));
        this.opts.add(new Attribute("remove_repository", repo));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        return this.run(CMD_UPDATE);
    }

    public SSHCommandResult update_add_package(String pkg) {
        this.opts.clear();
        this.opts.add(new Attribute("add_package", pkg));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        return this.run(CMD_UPDATE);
    }

    public SSHCommandResult update_remove_package(String pkg) {
        this.opts.clear();
        this.opts.add(new Attribute("remove_package", pkg));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        return this.run(CMD_UPDATE);
    }

    public SSHCommandResult update_add_param(String param, String value) {
        this.opts.clear();
        this.opts.add(new Attribute("add_param", param));
        this.opts.add(new Attribute("value", value));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        return this.run(CMD_UPDATE);
    }

    public SSHCommandResult update_remove_param(String param) {
        this.opts.clear();
        this.opts.add(new Attribute("remove_param", param));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        return this.run(CMD_UPDATE);
    }

    public SSHCommandResult update_name(String newname) {
        this.opts.clear();
        this.opts.add(new Attribute("new_name", newname));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        return this.run(CMD_UPDATE);
    }

    public SSHCommandResult update_add_package_group(String pkgGrp) {
        this.opts.clear();
        this.opts.add(new Attribute("add_package_group", pkgGrp));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        return this.run(CMD_UPDATE);
    }

    public SSHCommandResult update_remove_package_group(String pkgGrp) {
        this.opts.clear();
        this.opts.add(new Attribute("remove_package_group", pkgGrp));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        return this.run(CMD_UPDATE);
    }

    public SSHCommandResult export(String environment, String file, String format) {
        this.opts.clear();
        this.opts.add(new Attribute("file", file));
        this.opts.add(new Attribute("format", format));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("environment", environment));
        return this.run(CMD_EXPORT);
    }
}

