/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.base.obj;

import com.redhat.qe.katello.base.KatelloCliTestScript;
import com.redhat.qe.katello.base.obj._KatelloObject;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.logging.Logger;
import javax.management.Attribute;
import org.testng.Assert;

public class KatelloProduct
extends _KatelloObject {
    protected static Logger log = Logger.getLogger(KatelloProduct.class.getName());
    public static final String RHEL_SERVER = "Red Hat Enterprise Linux Server";
    public static final String Default_Org = "ACME_Corporation";
    public static final String CMD_CREATE = "product create";
    public static final String CLI_CMD_LIST = "product list -v";
    public static final String CMD_STATUS = "product status";
    public static final String CMD_SYNC = "product synchronize";
    public static final String CMD_PROMOTE = "product promote";
    public static final String CMD_DELETE = "product delete";
    public static final String CMD_SET_PLAN = "product set_plan";
    public static final String ERR_COULD_NOT_FIND_PRODUCT = "Could not find product [ %s ] within organization [ %s ]";
    public static final String OUT_CREATED = "Successfully created product [ %s ]";
    public static final String OUT_PROMOTED = "Product [ %s ] promoted to environment [ %s ]";
    public static final String OUT_SYNCHRONIZED = "Product [ %s ] synchronized";
    public static final String OUT_DELETED = "Deleted product '%s'";
    public static final String OUT_NOT_SYNCHRONIZED_YET = "Product '%s' was not synchronized yet";
    public static final String ERR_PROMOTE_NOREPOS = "Couldn't find Product with cp_id = ";
    public static final String ERR_GPGKEY_NOTFOUND = "Couldn't find GpgKey with name = %s";
    public static final String API_CMD_LIST = "/organizations/%s/products";
    public static final String REG_PROD_LIST = ".*Id\\s*:\\s+\\d+.*Name\\s*:\\s+%s.*Provider Id\\s*:\\s+\\d+.*Provider Name\\s*:\\s+%s.*Sync Plan Name\\s*:\\s+%s.*Last Sync\\s*:\\s+%s.*GPG key\\s*:\\s*%s.*";
    public static final String REG_PROD_STATUS = ".*Id\\s*:\\s+\\d+.*Name\\s*:\\s+%s.*Provider Id\\s*:\\s+\\d+.*Provider Name\\s*:\\s+%s.*Last Sync\\s*:\\s+.*Sync State\\s*:\\s+%s.*";
    public static final String REG_PROD_LASTSYNC = "\\d{4}/\\d{2}/\\d{2}\\s\\d{2}:\\d{2}:\\d{2}";
    public String name;
    String org;
    public String provider;
    public String providerId;
    public String syncPlanName;
    public String lastSync;
    public String syncState;
    String description;
    public String gpgkey;
    String url;
    boolean nodisc = false;
    boolean assumeyes = false;

    public KatelloProduct(String pName, String pOrg, String pProv, String pDesc, String pGpgkey, String pUrl, Boolean bNodisc, Boolean bAssumeyes) {
        this.name = pName;
        this.org = pOrg;
        this.provider = pProv;
        this.description = pDesc;
        this.gpgkey = pGpgkey;
        this.url = pUrl;
        if (bNodisc != null) {
            this.nodisc = bNodisc;
        }
        if (bAssumeyes != null) {
            this.assumeyes = bAssumeyes;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SSHCommandResult create() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("provider", this.provider));
        this.opts.add(new Attribute("description", this.description));
        this.opts.add(new Attribute("gpgkey", this.gpgkey));
        this.opts.add(new Attribute("url", this.url));
        if (this.nodisc) {
            this.opts.add(new Attribute("nodisc", ""));
        }
        if (this.assumeyes) {
            this.opts.add(new Attribute("assumeyes", ""));
        }
        return this.run(CMD_CREATE);
    }

    public SSHCommandResult cli_list() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("provider", this.provider));
        return this.run(CLI_CMD_LIST);
    }

    public SSHCommandResult cli_list(String environment) {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("environment", environment));
        return this.run(CLI_CMD_LIST);
    }

    public SSHCommandResult cli_list_provider(String prov) {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("provider", prov));
        return this.run(CLI_CMD_LIST);
    }

    public SSHCommandResult status() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        return this.run(CMD_STATUS);
    }

    public SSHCommandResult cli_set_plan(String plan) {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("plan", plan));
        return this.run(CMD_SET_PLAN);
    }

    public SSHCommandResult synchronize() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        return this.run(CMD_SYNC);
    }

    public SSHCommandResult promote(String environment) {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("environment", environment));
        return this.run(CMD_PROMOTE);
    }

    public SSHCommandResult delete() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        return this.run(CMD_DELETE);
    }

    public void assert_productExists(String envName, boolean synced) {
        String REGEXP_PRODUCT_LIST = ".*Name\\s*:\\s+" + this.name + ".*Provider Name\\s*:\\s+" + this.provider + ".*";
        log.info("Assertions: product exists");
        SSHCommandResult res = this.cli_list();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)KatelloCliTestScript.sgetOutput(res).replaceAll("\n", "").matches(REGEXP_PRODUCT_LIST), (String)"List should contain info about product (requested by: provider)");
        if (envName != null) {
            res = this.cli_list(envName);
            Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
            Assert.assertTrue((boolean)KatelloCliTestScript.sgetOutput(res).replaceAll("\n", "").matches(REGEXP_PRODUCT_LIST), (String)"List should contain info about product (requested by: environment)");
        }
        if (!synced) {
            res = this.status();
            Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
            String REGEXP_PRODUCT_STATUS = ".*Name\\s*:\\s+" + this.name + ".*Provider Name\\s*:\\s+" + this.provider + ".*Last Sync\\s*:\\s+never.*Sync State\\s*:\\s+Not synced.*";
            Assert.assertTrue((boolean)KatelloCliTestScript.sgetOutput(res).replaceAll("\n", "").matches(REGEXP_PRODUCT_STATUS), (String)"List should contain status of product (not synced)");
        }
    }
}

