/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tasks.impl;

import com.google.inject.Inject;
import com.redhat.qe.katello.base.KatelloApiException;
import com.redhat.qe.katello.base.obj.KatelloEntitlement;
import com.redhat.qe.katello.base.obj.KatelloEnvironment;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.base.obj.KatelloPool;
import com.redhat.qe.katello.base.obj.KatelloProduct;
import com.redhat.qe.katello.base.obj.KatelloProvider;
import com.redhat.qe.katello.base.obj.KatelloRepo;
import com.redhat.qe.katello.base.obj.KatelloSerial;
import com.redhat.qe.katello.base.obj.KatelloSystem;
import com.redhat.qe.katello.base.obj.KatelloUser;
import com.redhat.qe.katello.resource.ConsumerResource;
import com.redhat.qe.katello.resource.OrganizationResource;
import com.redhat.qe.katello.resource.PoolResource;
import com.redhat.qe.katello.resource.ProviderResource;
import com.redhat.qe.katello.resource.RepositoryResource;
import com.redhat.qe.katello.resource.SystemResource;
import com.redhat.qe.katello.resource.UserResource;
import com.redhat.qe.katello.tasks.KatelloTasks;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class KatelloApiTasks
implements KatelloTasks {
    @Inject
    protected Logger log;
    private final OrganizationResource orgResource;
    private final ProviderResource providerResource;
    private final RepositoryResource repositoryResource;
    private final ConsumerResource consumerResource;
    private final UserResource userResource;
    private final PoolResource poolResource;
    private final SystemResource systemResource;

    @Inject
    KatelloApiTasks(OrganizationResource orgResource, ProviderResource providerResource, RepositoryResource repositoryResource, ConsumerResource consumerResource, UserResource userResource, PoolResource poolResource, SystemResource systemResource) {
        this.orgResource = orgResource;
        this.providerResource = providerResource;
        this.repositoryResource = repositoryResource;
        this.consumerResource = consumerResource;
        this.userResource = userResource;
        this.poolResource = poolResource;
        this.systemResource = systemResource;
    }

    @Override
    public String uploadManifest(Long providerId, String exportZipPath) {
        HashMap<String, DataSource> parts = new HashMap<String, DataSource>();
        parts.put("file", (DataSource)new FileDataSource(new File(exportZipPath)));
        ClientResponse<String> response = this.providerResource.import_manifest(providerId, parts);
        return response.toString();
    }

    @Override
    public KatelloEnvironment getEnvironment(String orgName, String envName) {
        KatelloEnvironment _return = null;
        try {
            this.log.info(String.format("Retrieve environment: [%s] of Org: [%s]", envName, orgName));
            ClientResponse<List<KatelloEnvironment>> envResponse = this.orgResource.listEnvironments(orgName);
            List envs = (List)envResponse.getEntity();
            for (KatelloEnvironment env : envs) {
                if (!env.getName().equals(envName)) continue;
                return env;
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        return _return;
    }

    @Override
    public String deleteEnvironment(String orgName, String envName) throws KatelloApiException {
        ClientResponse<String> _return = null;
        Long envId = this.getEnvironment(orgName, envName).getId();
        _return = this.orgResource.deleteEnvironment(orgName, envId);
        if (_return.getStatus() > 299) {
            throw new KatelloApiException(_return);
        }
        this.log.info(String.format("Deleted the environment [%s] of org: [%s]", envName, orgName));
        return (String)_return.getEntity();
    }

    @Override
    public KatelloEnvironment getEnvFromOrgList(String orgName, String envName) {
        List envs = (List)this.orgResource.listEnvironments(orgName).getEntity();
        for (KatelloEnvironment env : envs) {
            if (!env.getName().equals(envName)) continue;
            return env;
        }
        return null;
    }

    @Override
    public List<KatelloOrg> getOrganizations() throws KatelloApiException {
        ClientResponse<List<KatelloOrg>> _return = null;
        _return = this.orgResource.list();
        if (_return.getStatus() > 299) {
            throw new KatelloApiException(_return);
        }
        this.log.info(String.format("Org list returned with %d entries", ((List)_return.getEntity()).size()));
        return (List)_return.getEntity();
    }

    @Override
    public KatelloOrg getOrganization(String organizationKey) throws KatelloApiException {
        ClientResponse<KatelloOrg> _return = null;
        _return = this.orgResource.getOrganization(organizationKey);
        if (_return.getStatus() > 299) {
            throw new KatelloApiException(_return);
        }
        return (KatelloOrg)_return.getEntity();
    }

    @Override
    public KatelloSystem getConsumer(String consumer_id) throws KatelloApiException {
        ClientResponse<KatelloSystem> _return = null;
        _return = this.consumerResource.get(consumer_id);
        if (_return.getStatus() > 299) {
            throw new KatelloApiException(_return);
        }
        return (KatelloSystem)_return.getEntity();
    }

    @Override
    public List<KatelloSystem> listConsumers() throws KatelloApiException {
        ClientResponse<List<KatelloSystem>> _return = null;
        _return = this.systemResource.list();
        if (_return.getStatus() > 299) {
            throw new KatelloApiException(_return);
        }
        return (List)_return.getEntity();
    }

    @Override
    public List<KatelloProduct> getProductsByOrg(String org_name) throws KatelloApiException {
        ClientResponse<List<KatelloProduct>> _return = null;
        _return = this.orgResource.listProducts(org_name);
        if (_return.getStatus() > 299) {
            throw new KatelloApiException(_return);
        }
        return (List)_return.getEntity();
    }

    @Override
    public List<Long> getSerials(String consumerId) throws KatelloApiException {
        ArrayList<Long> _return = new ArrayList<Long>();
        ClientResponse<List<KatelloSerial>> serialsResponse = this.consumerResource.listSerials(consumerId);
        if (serialsResponse.getStatus() > 299) {
            throw new KatelloApiException(serialsResponse);
        }
        for (KatelloSerial serial : (List)serialsResponse.getEntity()) {
            _return.add(serial.getId());
        }
        return _return;
    }

    @Override
    public List<KatelloEnvironment> getEnvironments(String org_name) throws KatelloApiException {
        ClientResponse<List<KatelloEnvironment>> _return = null;
        _return = this.orgResource.listEnvironments(org_name);
        if (_return.getStatus() > 299) {
            throw new KatelloApiException(_return);
        }
        return (List)_return.getEntity();
    }

    @Override
    public List<KatelloProvider> listProviders(String org_name) throws KatelloApiException {
        ClientResponse<List<KatelloProvider>> _return = null;
        _return = this.orgResource.listProviders(org_name);
        if (_return.getStatus() > 299) {
            throw new KatelloApiException(_return);
        }
        return (List)_return.getEntity();
    }

    @Override
    public KatelloUser createUser(String username, String email, String password, boolean disabled) throws KatelloApiException {
        ClientResponse<KatelloUser> _return = null;
        HashMap<String, Object> user = new HashMap<String, Object>();
        user.put("username", username);
        user.put("password", password);
        user.put("email", email);
        user.put("disabled", disabled);
        _return = this.userResource.create(user);
        if (_return.getStatus() > 299) {
            throw new KatelloApiException(_return);
        }
        return (KatelloUser)_return.getEntity();
    }

    @Override
    public List<KatelloUser> listUsers() throws KatelloApiException {
        ClientResponse<List<KatelloUser>> _return = null;
        _return = this.userResource.list();
        if (_return.getStatus() > 299) {
            throw new KatelloApiException(_return);
        }
        return (List)_return.getEntity();
    }

    @Override
    public KatelloUser getUser(Long userId) throws KatelloApiException {
        ClientResponse<KatelloUser> _return = null;
        _return = this.userResource.get(userId);
        if (_return.getStatus() > 299) {
            throw new KatelloApiException(_return);
        }
        return (KatelloUser)_return.getEntity();
    }

    @Override
    public KatelloOrg createOrganization(String org_name, String org_description) throws KatelloApiException {
        ClientResponse<KatelloOrg> _return = null;
        HashMap<String, Object> orgPost = new HashMap<String, Object>();
        orgPost.put("name", org_name);
        orgPost.put("description", org_description);
        _return = this.orgResource.create(orgPost);
        if (_return.getStatus() > 299) {
            throw new KatelloApiException(_return);
        }
        this.log.info(String.format("Create an org with: name=[%s]; description=[%s]", org_name, org_description));
        return (KatelloOrg)_return.getEntity();
    }

    @Override
    public KatelloEnvironment createEnvironment(String orgKey, String env_name, String env_descr, String prior) throws KatelloApiException {
        ClientResponse<KatelloEnvironment> _return = null;
        HashMap<String, Object> envPost = new HashMap<String, Object>();
        envPost.put("name", env_name);
        envPost.put("description", env_descr);
        Long priorId = null;
        List envs = (List)this.orgResource.listEnvironments(orgKey).getEntity();
        for (KatelloEnvironment env : envs) {
            if (!env.getName().equals(prior)) continue;
            priorId = env.getId();
            break;
        }
        envPost.put("prior", priorId);
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("environment", envPost);
        _return = this.orgResource.createEnvironment(orgKey, env);
        if (_return.getStatus() > 299) {
            throw new KatelloApiException(_return);
        }
        this.log.info(String.format("Create environment with: name=[%s]; description=[%s]; org=[%s]", env_name, env_descr, orgKey));
        return (KatelloEnvironment)_return.getEntity();
    }

    @Override
    public KatelloProvider createProvider(String orgName, String providerName, String description, String type, String url) throws KatelloApiException {
        ClientResponse<KatelloProvider> _return = null;
        try {
            HashMap<String, Object> katelloProviderPost = new HashMap<String, Object>();
            katelloProviderPost.put("organization_id", orgName);
            HashMap<String, String> provider = new HashMap<String, String>();
            provider.put("name", providerName);
            provider.put("description", description);
            provider.put("provider_type", type);
            if (url != null && !url.isEmpty()) {
                provider.put("repository_url", url);
            }
            katelloProviderPost.put("provider", provider);
            _return = this.providerResource.create(katelloProviderPost);
            if (_return.getStatus() > 299) {
                throw new KatelloApiException(_return);
            }
            this.log.info(String.format("Created a provider with: name=[%s]; description=[%s]; provider_type=[%s], repository_url=[%s]", providerName, description, type, url));
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        return (KatelloProvider)_return.getEntity();
    }

    @Override
    public KatelloProduct createProduct(String org_name, String provider_name, String productName, String productDescription, String productUrl) throws KatelloApiException {
        ClientResponse<KatelloProduct> _return = null;
        try {
            HashMap<String, Object> katelloProduct = new HashMap<String, Object>();
            HashMap<String, String> product = new HashMap<String, String>();
            product.put("name", productName);
            product.put("description", productDescription);
            product.put("url", productUrl);
            katelloProduct.put("product", product);
            Long providerId = this.getProvider(org_name, provider_name).getId();
            _return = this.providerResource.create(providerId, katelloProduct);
            if (_return.getStatus() > 299) {
                throw new KatelloApiException(_return);
            }
            this.log.info(String.format("Created a product for provider: [%s] with: name=[%s]; description=[%s]; url=[%s]", provider_name, productName, productDescription, productUrl));
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        return (KatelloProduct)_return.getEntity();
    }

    @Override
    public KatelloRepo createRepository(String providerName, String candlepin_id, String repo_name, String repo_url) throws KatelloApiException {
        ClientResponse<KatelloRepo> _return = null;
        try {
            HashMap<String, String> repository = new HashMap<String, String>();
            repository.put("name", repo_name);
            repository.put("product_id", candlepin_id);
            repository.put("url", repo_url);
            _return = this.repositoryResource.create(repository);
            if (_return.getStatus() > 299) {
                throw new KatelloApiException(_return);
            }
            this.log.info(String.format("Created a repo for provider: [%s] with: name=[%s]; product_id=[%s]; url=[%s]", providerName, repo_name, candlepin_id, repo_url));
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        return (KatelloRepo)_return.getEntity();
    }

    @Override
    public List<KatelloProduct> import_products(String orgName, String providerName, Map<String, Object> products) throws KatelloApiException {
        ClientResponse<List<KatelloProduct>> _return = null;
        Long providerId = this.getProvider(orgName, providerName).getId();
        try {
            _return = this.providerResource.import_products(providerId, products);
            if (_return.getStatus() > 299) {
                throw new KatelloApiException(_return);
            }
            this.log.info(String.format("Importing product(s) for provider: id=[%s]", providerId));
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        return (List)_return.getEntity();
    }

    @Override
    public List<KatelloProduct> listProducts(String orgName) throws KatelloApiException {
        ClientResponse<List<KatelloProduct>> _return = null;
        _return = this.orgResource.listProducts(orgName);
        if (_return.getStatus() > 299) {
            throw new KatelloApiException(_return);
        }
        return (List)_return.getEntity();
    }

    @Override
    public KatelloProduct getProductByOrg(String orgName, String productName) throws KatelloApiException {
        try {
            List<KatelloProduct> products = this.listProducts(orgName);
            if (products.size() == 0) {
                return null;
            }
            this.log.info(String.format("Get product: name=[%s]", productName));
            for (KatelloProduct product : products) {
                if (!product.getName().equals(productName)) continue;
                return product;
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        return null;
    }

    @Override
    public String subscribeConsumer(String consumerId) throws KatelloApiException {
        ClientResponse<String> _return = null;
        _return = this.consumerResource.subscribe(consumerId);
        if (_return.getStatus() > 299) {
            throw new KatelloApiException(_return);
        }
        this.log.info(String.format("Subscribing consumer: [%s]", consumerId));
        return (String)_return.getEntity();
    }

    @Override
    public List<KatelloEntitlement> subscribeConsumerWithProduct(String consumerId, String[] productIds) throws KatelloApiException {
        ClientResponse<List<KatelloEntitlement>> _return = null;
        _return = this.consumerResource.subscribeWithProductIds(consumerId, productIds);
        if (_return.getStatus() > 299) {
            throw new KatelloApiException(_return);
        }
        this.log.info(String.format("Subscribing consumer: [%s]", consumerId));
        return (List)_return.getEntity();
    }

    @Override
    public List<KatelloEntitlement> subscribeConsumerWithPool(String consumerId, String poolId) throws KatelloApiException {
        ClientResponse<List<KatelloEntitlement>> _return = null;
        _return = this.consumerResource.subscribeWithPool(consumerId, poolId);
        if (_return.getStatus() > 299) {
            throw new KatelloApiException(_return);
        }
        this.log.info(String.format("Subscribing consumer: [%s] to the pool: [%s]", consumerId, poolId));
        return (List)_return.getEntity();
    }

    @Override
    public KatelloSystem subscribeConsumerViaSystem(String consumerId, String poolId) throws KatelloApiException {
        ClientResponse<KatelloSystem> _return = null;
        HashMap<String, Object> pool = new HashMap<String, Object>();
        pool.put("pool", poolId);
        pool.put("quantity", 1L);
        _return = this.systemResource.subscribe(consumerId, pool);
        if (_return.getStatus() > 299) {
            throw new KatelloApiException(_return);
        }
        this.log.info(String.format("Subscribing consumer: [%s] to the pool: [%s]", consumerId, poolId));
        return (KatelloSystem)_return.getEntity();
    }

    @Override
    public List<KatelloEntitlement> registerSystemWithActivationKey(String consumerId, String activationKey, String hostname, String uuid, String orgName, String serviceLevel) throws KatelloApiException {
        ClientResponse<List<KatelloEntitlement>> _return = null;
        HashMap<String, Object> activationInfo = new HashMap<String, Object>();
        activationInfo.put("activation_keys", activationKey);
        activationInfo.put("facts", this.createFacts(hostname, uuid, orgName));
        activationInfo.put("installedProducts", this.createPackages());
        activationInfo.put("name", hostname);
        activationInfo.put("type", "system");
        activationInfo.put("serviceLevel", serviceLevel);
        _return = this.orgResource.registerWithActivationKey(consumerId, activationInfo);
        if (_return.getStatus() > 299) {
            throw new KatelloApiException(_return);
        }
        this.log.info(String.format("Subscribing consumer: [%s] with activation key: [%s]", consumerId, activationKey));
        return (List)_return.getEntity();
    }

    @Override
    public KatelloProvider getProvider(String org_name, String byName) throws KatelloApiException {
        ClientResponse<List<KatelloProvider>> providers = this.orgResource.listProviders(org_name);
        for (KatelloProvider provider : (List)providers.getEntity()) {
            if (!provider.getName().equals(byName)) continue;
            return provider;
        }
        return null;
    }

    @Override
    public String getPool(String poolName) throws KatelloApiException {
        List<KatelloPool> pools = this.getPools();
        for (KatelloPool pool : pools) {
            if (!pool.getProductName().equals(poolName)) continue;
            return pool.getId();
        }
        return null;
    }

    @Override
    public List<KatelloPool> getPools() throws KatelloApiException {
        ClientResponse<List<KatelloPool>> _return = null;
        _return = this.poolResource.list();
        if (_return.getStatus() > 299) {
            throw new KatelloApiException(_return);
        }
        return (List)_return.getEntity();
    }

    private String deleteProvider(String orgName, KatelloProvider provider) throws KatelloApiException {
        ClientResponse<String> _return = null;
        Long providerId = this.getProvider(orgName, provider.getName()).getId();
        _return = this.providerResource.delete(providerId);
        this.log.info("Delete provider: name=[" + provider.getName() + "]; id=[" + providerId + "]");
        return (String)_return.getEntity();
    }

    @Override
    public String deleteProvider(KatelloProvider provider) throws KatelloApiException {
        List orgs = (List)this.orgResource.list().getEntity();
        for (KatelloOrg org : orgs) {
            if (!org.getId().equals(provider.getOrganizationId())) continue;
            return this.deleteProvider(org.name, provider);
        }
        return "Could not delete provider";
    }

    @Override
    public KatelloSystem createConsumer(String orgName, String hostname, String uuid) throws KatelloApiException {
        ClientResponse<KatelloSystem> _return = null;
        HashMap<String, Object> sFacts = new HashMap();
        sFacts = this.createFacts(hostname, uuid, orgName);
        this.log.info(String.format("Creating consumer with: uuid=[%s]; hostname=[%s]; org_name=[%s]", uuid, hostname, orgName));
        _return = this.consumerResource.create(orgName, sFacts);
        if (_return.getStatus() > 299) {
            throw new KatelloApiException(_return);
        }
        return (KatelloSystem)_return.getEntity();
    }

    @Override
    public KatelloSystem updateFacts(String consumerId, String component, String updValue) throws KatelloApiException {
        ClientResponse<KatelloSystem> _return = null;
        Map<String, String> facts = ((KatelloSystem)this.consumerResource.get(consumerId).getEntity()).getFacts();
        facts.put(component, updValue);
        HashMap<String, Object> updFacts = new HashMap<String, Object>();
        updFacts.put("facts", facts);
        try {
            Thread.sleep(1000L);
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.log.finest(String.format("Update consumer: [%s] facts with: [%s=%s]", consumerId, component, updValue));
        _return = this.consumerResource.update(consumerId, updFacts);
        if (_return.getStatus() > 299) {
            throw new KatelloApiException(_return);
        }
        return (KatelloSystem)_return.getEntity();
    }

    @Override
    public KatelloEnvironment updateEnvProperty(String organizationName, String environmentName, String component, Object updValue) throws KatelloApiException {
        ClientResponse<KatelloEnvironment> _return = null;
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put(component, updValue);
        HashMap<String, Object> updEnv = new HashMap<String, Object>();
        updEnv.put("environment", env);
        Long envId = this.getEnvironment(organizationName, environmentName).getId();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception ex) {
            // empty catch block
        }
        _return = this.orgResource.updateEnvironment(organizationName, envId, updEnv);
        if (_return.getStatus() > 299) {
            throw new KatelloApiException(_return);
        }
        return (KatelloEnvironment)_return.getEntity();
    }

    @Override
    public KatelloProvider updateProviderProperty(String organizationName, String providerName, String component, Object updValue) throws KatelloApiException {
        ClientResponse<KatelloProvider> _return = null;
        HashMap<String, Object> prov = new HashMap<String, Object>();
        prov.put(component, updValue);
        HashMap<String, Object> updProv = new HashMap<String, Object>();
        updProv.put("provider", prov);
        Long providerId = this.getProvider(organizationName, providerName).getId();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception ex) {
            // empty catch block
        }
        _return = this.providerResource.update(providerId, updProv);
        if (_return.getStatus() > 299) {
            throw new KatelloApiException(_return);
        }
        return (KatelloProvider)_return.getEntity();
    }

    @Override
    public String updateUser(Long userId, String component, Object updValue) throws KatelloApiException {
        ClientResponse<String> _return = null;
        HashMap<String, Object> userProp = new HashMap<String, Object>();
        userProp.put(component, updValue);
        HashMap<String, Object> updUser = new HashMap<String, Object>();
        updUser.put("user", userProp);
        try {
            Thread.sleep(1000L);
        }
        catch (Exception ex) {
            // empty catch block
        }
        _return = this.userResource.update(userId, updUser);
        if (_return.getStatus() > 299) {
            throw new KatelloApiException(_return);
        }
        return (String)_return.getEntity();
    }

    @Override
    public KatelloSystem updatePackages(KatelloSystem consumer) throws KatelloApiException {
        ClientResponse<KatelloSystem> _return = null;
        List<Map<String, Object>> packages = this.createPackages();
        _return = this.consumerResource.updatePackages(consumer.getUuid(), packages);
        if (_return.getStatus() > 299) {
            throw new KatelloApiException(_return);
        }
        return (KatelloSystem)_return.getEntity();
    }

    @Override
    public String deleteUser(Long userId) throws KatelloApiException {
        ClientResponse<String> _return = null;
        _return = this.userResource.delete(userId);
        if (_return.getStatus() > 299) {
            throw new KatelloApiException(_return);
        }
        this.log.info(String.format("Remove user: id=[%s]", userId.toString()));
        return (String)_return.getEntity();
    }

    @Override
    public String deleteConsumer(String consumerId) throws KatelloApiException {
        ClientResponse<String> _return = null;
        _return = this.consumerResource.delete(consumerId);
        if (_return.getStatus() > 299) {
            throw new KatelloApiException(_return);
        }
        this.log.info(String.format("Remove consumer: uuid=[%s]", consumerId));
        return (String)_return.getEntity();
    }

    @Override
    public KatelloSystem unsubscribeConsumer(String consumerId, String serial) throws KatelloApiException {
        ClientResponse<KatelloSystem> _return = null;
        _return = this.consumerResource.unsubscribe(consumerId, serial);
        if (_return.getStatus() > 299) {
            throw new KatelloApiException(_return);
        }
        this.log.info(String.format("Unsubscribe consumer: uuid=[%s] from the product with: serial=[%s]", consumerId, serial));
        return (KatelloSystem)_return.getEntity();
    }

    @Override
    public KatelloSystem unsubscribeConsumer(String consumerId) throws KatelloApiException {
        ClientResponse<KatelloSystem> _return = null;
        _return = this.consumerResource.unsubscribe(consumerId);
        if (_return.getStatus() > 299) {
            throw new KatelloApiException(_return);
        }
        this.log.info(String.format("Unsubscribe consumer: uuid=[%s] from all entitlements", consumerId));
        return (KatelloSystem)_return.getEntity();
    }

    @Override
    public Long getEnvironmentPriorId(KatelloEnvironment env) {
        if (env.getPriorId() == null) {
            this.store_id(env);
        }
        return env.getPriorId();
    }

    private void store_id(KatelloEnvironment theEnv) {
        if (theEnv.getPriorId() == null) {
            List envs = (List)this.orgResource.listEnvironments(theEnv.getOrganizationKey()).getEntity();
            for (KatelloEnvironment env : envs) {
                if (!env.getName().equals(theEnv.getPrior())) continue;
                theEnv.setPriorId(env.getId());
                break;
            }
            if (theEnv.getPriorId() == null) {
                this.log.warning("Unable to retrieve environment.id for: [" + theEnv.getName() + "]");
            }
        }
    }

    private List<Map<String, Object>> createPackages() {
        Object[][] packages = new Object[][]{{"Red Hat, Inc.", "parted", 0L, "2.1", "17.el6", "x86_64"}, {"Red Hat, Inc.", "gstreamer-tools", 0L, "0.10.29", "1.el6", "x86_64"}, {"Red Hat, Inc.", "pm-utils", 0L, "1.2.5", "9.el6", "x86_64"}, {"Red Hat, Inc.", "iw", 0L, "0.9.17", "4.el6", "x86_64"}, {"Red Hat, Inc.", "crda", 0L, "1.1.1_2010.11.22", "1.el6", "x86_64"}, {"Red Hat, Inc.", "keyutils", 0L, "1.4", "3.el6", "x86_64"}, {"Red Hat, Inc.", "ntp", 0L, "4.2.4p8", "2.el6", "x86_64"}, {"Red Hat, Inc.", "libutempter", 0L, "1.1.5", "4.1.el6", "x86_64"}, {"Red Hat, Inc.", "cronie", 0L, "1.4.4", "7.el6", "x86_64"}, {"Red Hat, Inc.", "boost-iostreams", 0L, "1.41.0", "11.el6_1.2", "x86_64"}, {"Red Hat, Inc.", "certmonger", 0L, "0.50", "3.el6", "x86_64"}, {"Red Hat, Inc.", "upstart", 0L, "0.6.5", "10.el6", "x86_64"}};
        String[] keys = new String[]{"vendor", "name", "epoch", "version", "release", "arch"};
        ArrayList<Map<String, Object>> pkgsList = new ArrayList<Map<String, Object>>();
        for (Object[] pkg : packages) {
            HashMap<String, Object> pkgMap = new HashMap<String, Object>();
            for (int i = 0; i < keys.length; ++i) {
                pkgMap.put(keys[i], pkg[i]);
            }
            pkgsList.add(pkgMap);
        }
        return pkgsList;
    }

    private Map<String, Object> createFacts(String hostname, String uuid, String orgName) {
        HashMap<String, Object> allFacts = new HashMap<String, Object>();
        allFacts.put("org_name", orgName);
        HashMap<String, Object> facts = new HashMap<String, Object>();
        facts.put("dmi.bios.release_date", "01/01/2007");
        facts.put("net.interface.lo.ipaddr", "127.0.0.1");
        facts.put("network.hostname", hostname);
        facts.put("cpu.hypervisor_vendor", "KVM");
        facts.put("dmi.memory.type", "RAM");
        facts.put("dmi.bios.address", "0xe8000");
        facts.put("dmi.bios.runtime_size", "96 KB");
        facts.put("distribution.id", "Santiago");
        facts.put("dmi.memory.maximum_capacity", "1 GB");
        facts.put("dmi.chassis.asset_tag", "Not Specified");
        facts.put("dmi.memory.bank_locator", "Not Specified");
        facts.put("cpu.virtualization_type", "full");
        facts.put("net.interface.eth0.hwaddr", "54:52:00:69:55:b6");
        facts.put("dmi.system.wake-up_type", "Power Switch");
        facts.put("dmi.chassis.boot-up_state", "Safe");
        facts.put("distribution.name", "Red Hat Enterprise Linux Server");
        facts.put("cpu.thread(s)_per_core", "1");
        facts.put("dmi.chassis.manufacturer", "RED HAT");
        facts.put("dmi.bios.bios_revision", "1.0");
        facts.put("dmi.chassis.version", "Not Specified");
        facts.put("distribution.version", "6.3");
        facts.put("uname.version", "#1 SMP Tue Apr 5 19:58:31 EDT 2011");
        facts.put("net.interface.lo.hwaddr", "00:00:00:00:00:00");
        facts.put("dmi.bios.vendor", "QEMU");
        facts.put("dmi.memory.error_correction_type", "Multi-bit ECC");
        facts.put("dmi.memory.locator", "DIMM 0");
        facts.put("dmi.system.manufacturer", "Red Hat");
        facts.put("dmi.chassis.serial_number", "Not Specified");
        facts.put("dmi.bios.rom_size", "64 KB");
        facts.put("cpu.stepping", "3");
        facts.put("uname.release", "2.6.32-130.el6.x86_64");
        facts.put("dmi.system.uuid", uuid);
        facts.put("dmi.memory.array_handle", "0x1000");
        facts.put("cpu.cpu_op-mode(s)", "32-bit, 64-bit");
        facts.put("net.interface.eth0.netmask", "255.255.255.224");
        facts.put("dmi.memory.data_width", "64 bit");
        facts.put("memory.swaptotal", "1015800");
        facts.put("net.interface.lo.broadcast", "0.0.0.0");
        facts.put("dmi.chassis.lock", "Not Present");
        facts.put("cpu.cpu_mhz", "2793.074");
        facts.put("dmi.memory.speed", "  (ns)");
        facts.put("uname.machine", "x86_64");
        facts.put("dmi.memory.form_factor", "DIMM");
        facts.put("dmi.memory.total_width", "64 bit");
        facts.put("cpu.l1d_cache", "32K");
        facts.put("virt.is_guest", Boolean.TRUE);
        facts.put("cpu.cpu(s)", "1");
        facts.put("net.interface.lo.netmask", "255.0.0.0");
        facts.put("net.interface.eth0.broadcast", "10.34.56.31");
        facts.put("dmi.memory.error_information_handle", "Not Provided");
        facts.put("cpu.architecture", "x86_64");
        facts.put("cpu.vendor_id", "GenuineIntel");
        facts.put("dmi.processor.upgrade", "Other");
        facts.put("dmi.system.sku_number", "Not Specified");
        facts.put("cpu.bogomips", "5586.14");
        facts.put("dmi.memory.location", "Other");
        facts.put("dmi.chassis.thermal_state", "Safe");
        facts.put("dmi.system.serial_number", "Not Specified");
        facts.put("cpu.cpu_socket(s)", "1");
        facts.put("dmi.processor.voltage", " ");
        facts.put("uname.sysname", "Linux");
        facts.put("dmi.system.family", "Red Hat Enterprise Linux");
        facts.put("cpu.model", "6");
        facts.put("dmi.processor.version", "Not Specified");
        facts.put("uname.nodename", hostname);
        facts.put("dmi.chassis.power_supply_state", "Safe");
        facts.put("dmi.memory.use", "System Memory");
        facts.put("dmi.system.version", "Not Specified");
        facts.put("memory.memtotal", "1019852");
        facts.put("cpu.on-line_cpu(s)_list", "0");
        facts.put("dmi.system.status", "No errors detected");
        facts.put("dmi.bios.version", "QEMU");
        facts.put("cpu.numa_node(s)", "1");
        facts.put("dmi.chassis.security_status", "Unknown");
        facts.put("virt.host_type", "kvm");
        facts.put("dmi.chassis.type", "Other");
        facts.put("net.interface.eth0.ipaddr", "192.168.0.10");
        facts.put("dmi.processor.type", "Central Processor");
        facts.put("dmi.processor.socket_designation", "CPU 1");
        facts.put("dmi.system.product_name", "KVM");
        facts.put("cpu.byte_order", "Little Endian");
        facts.put("dmi.processor.status", "Populated:Enabled");
        facts.put("cpu.numa_node0_cpu(s)", "0");
        facts.put("cpu.core(s)_per_socket", "1");
        facts.put("dmi.memory.size", "1024 MB");
        facts.put("network.ipaddr", "192.168.0.10");
        facts.put("dmi.processor.family", "Other");
        facts.put("cpu.cpu_family", "6");
        allFacts.put("facts", facts);
        allFacts.put("name", hostname);
        allFacts.put("type", "system");
        return allFacts;
    }

    static {
        ResteasyProviderFactory instance = ResteasyProviderFactory.getInstance();
        RegisterBuiltin.register((ResteasyProviderFactory)instance);
    }
}

