/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.base.obj;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloCli;
import com.redhat.qe.katello.base.KatelloCliTestScript;
import com.redhat.qe.katello.base.obj.KatelloEnvironment;
import com.redhat.qe.katello.base.obj.KatelloTemplate;
import com.redhat.qe.katello.base.obj._KatelloObject;
import com.redhat.qe.tools.SSHCommandResult;
import javax.management.Attribute;

public class KatelloActivationKey
extends _KatelloObject {
    String org;
    String environment;
    String name;
    String description;
    String template;
    String limit;
    private String id;
    private String environment_id;
    private String template_id;
    public static final String CMD_CREATE = "activation_key create";
    public static final String CMD_INFO = "activation_key info";
    public static final String CMD_LIST = "activation_key list";
    public static final String CMD_DELETE = "activation_key delete";
    public static final String CMD_UPDATE = "activation_key update";
    public static final String CMD_ADD_SYSTEMGROUP = "activation_key add_system_group";
    public static final String CMD_REMOVE_SYSTEMGROUP = "activation_key remove_system_group";
    public static final String ERR_TEMPLATE_NOTFOUND = "Couldn't find template '%s'";
    public static final String OUT_CREATE = "Successfully created activation key [ %s ]";
    public static final String OUT_DELETE = "Successfully deleted activation key [ %s ]";
    public static final String OUT_ADD_SYSTEMGROUP = "Successfully added system group to activation key [ %s ]";
    public static final String OUT_REMOVE_SYSTEMGROUP = "Successfully removed system group from activation key [ %s ]";
    public static final String ERROR_INFO = "Could not find activation key [ %s ]";
    public static final String ERROR_EXCEED = "Usage limit (%s) exhausted for activation key '%s'";

    public KatelloActivationKey(String pOrg, String pEnv, String pName, String pDesc, String pTemplate) {
        this(pOrg, pEnv, pName, pDesc, pTemplate, null);
    }

    public KatelloActivationKey(String pOrg, String pEnv, String pName, String pDesc, String pTemplate, String pLimit) {
        this.org = pOrg;
        this.environment = pEnv;
        this.name = pName;
        this.description = pDesc;
        this.template = pTemplate;
        this.limit = pLimit;
    }

    public SSHCommandResult create() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("environment", this.environment));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("description", this.description));
        this.opts.add(new Attribute("template", this.template));
        this.opts.add(new Attribute("limit", this.limit));
        return this.run(CMD_CREATE);
    }

    public SSHCommandResult info() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        return this.run(CMD_INFO);
    }

    public SSHCommandResult list() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        return this.run("activation_key list -v");
    }

    public SSHCommandResult list(String pEnvironment) {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("environment", pEnvironment));
        return this.run("activation_key list -v");
    }

    public SSHCommandResult extend_limit(String newlimit) {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("limit", newlimit));
        return this.run(CMD_UPDATE);
    }

    public SSHCommandResult add_system_group(String pSystemGroup) {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("system_group", pSystemGroup));
        return this.run(CMD_ADD_SYSTEMGROUP);
    }

    public SSHCommandResult remove_system_group(String pSystemGroup) {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("system_group", pSystemGroup));
        return this.run(CMD_REMOVE_SYSTEMGROUP);
    }

    public SSHCommandResult delete() {
        this.opts.clear();
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("org", this.org));
        return this.run("activation_key delete -v");
    }

    public void asserts_create() {
        SSHCommandResult res;
        if (this.id == null) {
            this.updateIDs();
        }
        Assert.assertTrue(((res = this.list(this.environment)).getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (activation_key list)");
        String REGEXP_AK_LIST = ".*Id\\s*:\\s*\\d+.*Name\\s*:\\s*%s.*Environment Id\\s*:\\s*%s.*System Template Id\\s*:\\s*%s.*";
        String match_info = String.format(REGEXP_AK_LIST, this.name, this.environment_id, this.template_id).replaceAll("\"", "");
        if (this.template_id == null) {
            match_info = String.format(REGEXP_AK_LIST, this.name, this.environment_id, "None").replaceAll("\"", "");
        }
        Assert.assertTrue((boolean)KatelloCliTestScript.sgetOutput(res).replaceAll("\n", "").matches(match_info), (String)String.format("Activation key [%s] should be found in the list", this.name));
        res = this.info();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (activation_key info)");
        String REGEXP_AK_INFO = ".*Id\\s*:\\s*\\d+.*Name\\s*:\\s*%s.*Usage Limit\\s*:\\s*%s.*Environment Id\\s*:\\s*%s.*System Template Id\\s*:\\s*%s.*Pools\\s*:.*";
        match_info = String.format(REGEXP_AK_INFO, this.name, this.limit != null ? this.limit : "unlimited", this.environment_id, this.template_id).replaceAll("\"", "");
        if (this.template_id == null) {
            match_info = String.format(REGEXP_AK_INFO, this.name, this.limit != null ? this.limit : "unlimited", this.environment_id, "None").replaceAll("\"", "");
        }
        Assert.assertTrue((boolean)KatelloCliTestScript.sgetOutput(res).replaceAll("\n", "").matches(match_info), (String)String.format("Activation key [%s] should contain correct info", this.name));
    }

    private void updateIDs() {
        SSHCommandResult res;
        if (this.environment != null) {
            KatelloEnvironment env = new KatelloEnvironment(this.environment, null, this.org, "Library");
            res = env.cli_info();
            Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (environment info)");
            this.environment_id = KatelloCli.grepCLIOutput("Id", res.getStdout());
        }
        if (this.template != null) {
            KatelloTemplate tmpl = new KatelloTemplate(this.template, null, this.org, null);
            res = tmpl.info(this.environment);
            Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (template info)");
            this.template_id = KatelloCli.grepCLIOutput("Id", res.getStdout());
        }
        if (this.name != null) {
            res = this.info();
            this.id = KatelloCli.grepCLIOutput("Id", res.getStdout());
        }
    }
}

