/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.base;

import com.redhat.qe.auto.testng.TestScript;
import com.redhat.qe.katello.base.obj.KatelloUser;
import com.redhat.qe.katello.common.KatelloUtils;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.management.Attribute;

public class KatelloCli {
    protected static Logger log;
    public static final String OUT_EMPTY_LIST = "[  ]";
    private String command;
    private List<Attribute> args;
    private List<Attribute> opts;

    public KatelloCli(String command, List<Attribute> args, List<Attribute> options) {
        this.command = command;
        this.args = args;
        this.opts = options;
        if (this.args == null) {
            this.args = new ArrayList<Attribute>();
        }
        if (this.opts == null) {
            this.opts = new ArrayList<Attribute>();
        }
    }

    public KatelloCli(String command, List<Attribute> options) {
        this.command = command;
        this.args = new ArrayList<Attribute>();
        this.args.add(new Attribute("username", System.getProperty("katello.admin.user", "admin")));
        this.args.add(new Attribute("password", System.getProperty("katello.admin.password", "admin")));
        this.opts = options;
        if (this.opts == null) {
            this.opts = new ArrayList<Attribute>();
        }
    }

    public KatelloCli(String command, ArrayList<Attribute> options, KatelloUser user) {
        this.command = command;
        this.args = new ArrayList<Attribute>();
        this.args.add(new Attribute("username", user.username));
        this.args.add(new Attribute("password", user.password));
        this.opts = options;
        if (this.opts == null) {
            this.opts = new ArrayList<Attribute>();
        }
    }

    public SSHCommandResult run() {
        int i;
        String cmd = System.getProperty("katello.engine", "katello");
        for (i = 0; i < this.args.size(); ++i) {
            cmd = cmd + " --" + this.args.get(i).getName() + " \"" + this.args.get(i).getValue().toString() + "\"";
        }
        cmd = cmd + " " + this.command;
        for (i = 0; i < this.opts.size(); ++i) {
            if (this.opts.get(i).getValue() == null) continue;
            cmd = cmd + " --" + this.opts.get(i).getName() + " \"" + this.opts.get(i).getValue().toString() + "\"";
        }
        try {
            return KatelloUtils.sshOnClient(cmd);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String grepOutBlock(String property, String value, String output) {
        String[] lines;
        String _return = null;
        for (String line : lines = output.split("\\n\\n")) {
            if (line.startsWith("---") || line.trim().equals("") || !KatelloCli.grepCLIOutput(property, line).equals(value)) continue;
            _return = line.trim();
            break;
        }
        return _return;
    }

    public static String grepCLIOutput(String property, String output) {
        return KatelloCli.grepCLIOutput(property, output, 1);
    }

    public static String grepCLIOutput(String property, String output, int occurence) {
        int meet_cnt = 0;
        String[] lines = output.split("\\n");
        for (int i = 0; i < lines.length; ++i) {
            if (!lines[i].startsWith(property) || ++meet_cnt != occurence) continue;
            String[] split = lines[i].split(":\\s+");
            if (split.length < 2) {
                return lines[i + 1].trim();
            }
            return split[1].trim();
        }
        log.severe("ERROR: Output can not be extracted for the property: [" + property + "]");
        return null;
    }

    static {
        new TestScript();
        log = Logger.getLogger(KatelloCli.class.getName());
    }
}

