/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.api;

import com.google.inject.Inject;
import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloApiException;
import com.redhat.qe.katello.base.KatelloTestScript;
import com.redhat.qe.katello.base.obj.KatelloEnvironment;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.common.KatelloUtils;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"cfse-api", "headpin-api"})
public class EnvironmentsTest
extends KatelloTestScript {
    private String org_name;
    private String env_name;
    @Inject
    Logger log;

    @BeforeClass(description="Prepare an organization to work with", alwaysRun=true)
    public void setUp_createOrg() {
        String uid = KatelloUtils.getUniqueID();
        this.org_name = "auto-org-" + uid;
        String org_descr = "Test Organization " + uid;
        try {
            this.servertasks.createOrganization(this.org_name, org_descr);
        }
        catch (KatelloApiException e) {
            Assert.fail((String)"Could not create organization", (Throwable)e);
        }
    }

    @Test(groups={"testEnvs"}, description="List environments should be greater than 0")
    public void test_showEnvironments() {
        List<KatelloEnvironment> envs = null;
        try {
            envs = this.servertasks.getEnvironments(this.org_name);
        }
        catch (KatelloApiException e) {
            Assert.fail((String)"Could not list environments", (Throwable)e);
        }
        this.log.finer(String.format("Returned environments count is: [%s]", envs.size()));
        Assert.assertMore((Comparable)Integer.valueOf(envs.size()), (Comparable)Integer.valueOf(0), (String)"Should return environments >0");
    }

    @Test(groups={"testEnvs"}, description="Create an environment")
    public void test_createEnvironment_priorLocker() {
        String uid = KatelloUtils.getUniqueID();
        this.env_name = "auto-env-" + uid;
        String env_descr = "Test Environment " + uid;
        try {
            this.servertasks.createEnvironment(this.org_name, this.env_name, env_descr, "Library");
        }
        catch (KatelloApiException e) {
            Assert.fail((String)"Could not create environment", (Throwable)e);
        }
        KatelloEnvironment env = this.servertasks.getEnvFromOrgList(this.org_name, this.env_name);
        Assert.assertNotNull((Object)env, (String)"Should be in envs. list of the organization");
    }

    @Test(groups={"testEnvs"}, description="List an environment", dependsOnMethods={"test_createEnvironment_priorLocker"})
    public void test_listEnvironment() {
        KatelloEnvironment env = this.servertasks.getEnvironment(this.org_name, this.env_name);
        Assert.assertEquals((String)this.env_name, (String)env.getName(), (String)"Check: name");
        KatelloOrg org = null;
        try {
            org = this.servertasks.getOrganization(this.org_name);
        }
        catch (KatelloApiException e) {
            Assert.fail((String)"Could not get org info", (Throwable)e);
        }
        Assert.assertEquals((Object)org.getId(), (Object)env.getOrganizationId(), (String)"Check: organization_id");
    }

    @Test(groups={"testEnvs"}, description="Update environment properties", dependsOnMethods={"test_listEnvironment"})
    public void test_updateEnvironment() {
        KatelloEnvironment updEnv = null;
        KatelloEnvironment env = this.servertasks.getEnvironment(this.org_name, this.env_name);
        try {
            Date dupBefore = this.parseKatelloDate(env.getUpdatedAt());
            try {
                updEnv = this.servertasks.updateEnvProperty(this.org_name, this.env_name, "description", "Updated environment description");
            }
            catch (KatelloApiException e) {
                Assert.fail((String)"Could not update environment property", (Throwable)e);
            }
            Date dupAfter = this.parseKatelloDate(updEnv.getUpdatedAt());
            Assert.assertEquals((String)updEnv.getDescription(), (String)"Updated environment description", (String)"Check updated: description");
            Assert.assertMore((Comparable)Long.valueOf(dupAfter.getTime()), (Comparable)Long.valueOf(dupBefore.getTime()), (String)"Check the timestamp updated");
            String uid = KatelloUtils.getUniqueID();
            String env_prior = "dev-" + uid;
            try {
                env = this.servertasks.createEnvironment(this.org_name, env_prior, "Prior: " + env_prior, "Library");
            }
            catch (KatelloApiException e) {
                Assert.fail((String)"Could not create environment", (Throwable)e);
            }
            KatelloEnvironment priorEnv = this.servertasks.getEnvironment(this.org_name, env_prior);
            dupBefore = dupAfter;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                updEnv = this.servertasks.updateEnvProperty(this.org_name, this.env_name, "prior", priorEnv.getId());
            }
            catch (KatelloApiException e) {
                Assert.fail((String)"Could not update environment property", (Throwable)e);
            }
            Assert.assertEquals((Object)updEnv.getPriorId(), (Object)priorEnv.getId(), (String)("Check prior is " + env_prior));
        }
        catch (ParseException pex) {
            this.log.severe(pex.getMessage());
        }
    }

    @Test(groups={"testEnvs"}, description="Remove an environment created")
    public void test_deleteEnvironment() {
        String uid = KatelloUtils.getUniqueID();
        String env_name = "remove-env-" + uid;
        String env_descr = "To Be Removed - " + uid;
        try {
            this.servertasks.createEnvironment(this.org_name, env_name, env_descr, "Library");
        }
        catch (KatelloApiException e) {
            Assert.fail((String)"Failed to create environment", (Throwable)e);
        }
        String env_id = this.servertasks.getEnvironment(this.org_name, env_name).getId().toString();
        String res = null;
        try {
            res = this.servertasks.deleteEnvironment(this.org_name, env_name);
        }
        catch (KatelloApiException e) {
            Assert.fail((String)"Could not delete environemnt", (Throwable)e);
        }
        Assert.assertEquals((String)res, (String)("Deleted environment '" + env_id + "'"), (String)"Check the text returned");
        List<KatelloEnvironment> envs = null;
        try {
            envs = this.servertasks.getEnvironments(this.org_name);
        }
        catch (KatelloApiException e) {
            Assert.fail((String)"Could not list environments", (Throwable)e);
        }
        Assert.assertEquals((int)envs.indexOf(env_name), (int)-1, (String)String.format("Returned environment list does not contain: [%s]", env_name));
    }
}

