/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.base.obj;

import com.redhat.qe.katello.base.obj.KatelloUser;
import com.redhat.qe.katello.base.obj._KatelloObject;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.logging.Logger;
import javax.management.Attribute;
import org.codehaus.jackson.annotate.JsonProperty;

public class KatelloEnvironment
extends _KatelloObject {
    protected static Logger log = Logger.getLogger(KatelloEnvironment.class.getName());
    public static final String LIBRARY = "Library";
    public static final String CMD_CREATE = "environment create";
    public static final String CMD_INFO = "environment info -v";
    public static final String CLI_CMD_LIST = "environment list -v";
    public static final String CMD_DELETE = "environment delete";
    public static final String CMD_UPDATE = "environment update";
    public static final String OUT_CREATE = "Successfully created environment [ %s ]";
    public static final String OUT_DELETE = "Successfully deleted environment [ %s ]";
    public static final String ERROR_INFO = "Could not find environment [ %s ] within organization [ %s ]";
    public static final String OUT_UPDATE = "Successfully updated environment [ %s ]";
    public static final String API_CMD_LIST = "/organizations/%s/environments";
    public static final String API_CMD_CREATE = "/organizations/%s/environments";
    private String name;
    String description;
    String org;
    String prior;
    String label;
    private Long priorId;
    private Long id;
    private String updatedAt;
    private Long organizationId;
    private String organizationKey;

    public KatelloEnvironment() {
    }

    public KatelloEnvironment(String pName, String pDesc, String pOrg, String pPrior) {
        this.name = pName;
        this.description = pDesc;
        this.org = pOrg;
        this.prior = pPrior;
    }

    protected KatelloEnvironment(String name, String desc, String org, String prior, Long id, String updatedAt, Long organizationId) {
        this(name, desc, org, prior);
        this.id = id;
        this.updatedAt = updatedAt;
        this.organizationId = organizationId;
    }

    public KatelloEnvironment(String name, String desc, String org, String prior, String label) {
        this(name, desc, org, prior);
        this.label = label;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="updated_at")
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updated_at")
    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    @JsonProperty(value="organization_id")
    public Long getOrganizationId() {
        return this.organizationId;
    }

    @JsonProperty(value="organization_id")
    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    @JsonProperty(value="organization")
    public String getOrganizationKey() {
        return this.organizationKey;
    }

    @JsonProperty(value="organization")
    public void setOrganizationKey(String organizationKey) {
        this.organizationKey = organizationKey;
    }

    @JsonProperty(value="prior_id")
    public Long getPriorId() {
        return this.priorId;
    }

    @JsonProperty(value="prior_id")
    public void setPriorId(Long priorId) {
        this.priorId = priorId;
    }

    public String getPrior() {
        return this.prior;
    }

    public void setPrior(String prior) {
        this.prior = prior;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public SSHCommandResult cli_create() {
        return this.cli_create(null);
    }

    public SSHCommandResult cli_create(KatelloUser user) {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("description", this.description));
        this.opts.add(new Attribute("prior", this.prior));
        this.opts.add(new Attribute("label", this.label));
        return this.run(CMD_CREATE);
    }

    public SSHCommandResult cli_info() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        return this.run(CMD_INFO);
    }

    public SSHCommandResult cli_list() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        return this.run(CLI_CMD_LIST);
    }

    public SSHCommandResult cli_delete() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        return this.run(CMD_DELETE);
    }

    public SSHCommandResult cli_update(String descr) {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("description", descr));
        this.opts.add(new Attribute("prior", this.prior));
        this.opts.add(new Attribute("label", this.label));
        return this.run(CMD_UPDATE);
    }
}

