/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.cli;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloCliDataProvider;
import com.redhat.qe.katello.base.KatelloCliTestScript;
import com.redhat.qe.katello.base.obj.KatelloEnvironment;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.common.KatelloUtils;
import com.redhat.qe.tools.SSHCommandResult;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class EnvironmentTests
extends KatelloCliTestScript {
    private String organization;

    @BeforeClass(description="init: create org stuff", groups={"headpin-cli"})
    public void setUp() {
        String uid = KatelloUtils.getUniqueID();
        this.organization = "env-" + uid;
        KatelloOrg org = new KatelloOrg(this.organization, null);
        SSHCommandResult res = org.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
    }

    @Test(description="create Environment", groups={"headpin-cli"}, dataProvider="environment_create", dataProviderClass=KatelloCliDataProvider.class, enabled=true)
    public void testEnv_create(String name, String descr, Integer exitCode, String output) {
        KatelloEnvironment env = new KatelloEnvironment(name, descr, this.organization, "Library");
        SSHCommandResult res = env.cli_create();
        Assert.assertTrue((res.getExitCode().intValue() == exitCode.intValue() ? 1 : 0) != 0, (String)"Check - return code");
        if (exitCode == 0) {
            Assert.assertTrue((boolean)this.getOutput(res).contains(output), (String)"Check - returned output string");
        } else {
            Assert.assertTrue((boolean)this.getOutput(res).contains(output), (String)"Check - returned error string");
        }
    }

    @Test(description="Environment info", groups={"headpin-cli"})
    public void testEnv_info() {
        String descr;
        String uid = KatelloUtils.getUniqueID();
        String name = "env-" + uid;
        KatelloEnvironment env = new KatelloEnvironment(name, descr = "Environment " + name + " Created", this.organization, "Library");
        SSHCommandResult res = env.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully created environment [ %s ]", name)), (String)"Check - returned output string (environment create)");
        res = env.cli_info();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
    }

    @Test(description="delete a environment", groups={"headpin-cli"}, enabled=true)
    public void test_delete_environment() {
        String uid = KatelloUtils.getUniqueID();
        String envName = "env-delete_act_key-" + uid;
        KatelloEnvironment env = new KatelloEnvironment(envName, "Environment created", this.organization, "Library");
        SSHCommandResult res = env.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (environment create)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully created environment [ %s ]", envName)), (String)"Check - returned output string (environment create)");
        res = env.cli_delete();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (environment delete)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully deleted environment [ %s ]", envName)), (String)"Check - returned output string (environment delete)");
        res = env.cli_info();
        Assert.assertTrue((res.getExitCode() == 65 ? 1 : 0) != 0, (String)"Check - return code (environment delete)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Could not find environment [ %s ] within organization [ %s ]", envName, this.organization)), (String)"Check - returned output string (environment info -v)");
        res = env.cli_list();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (environment list)");
    }

    @Test(description="Environment update", groups={"headpin-cli"})
    public void testEnv_update() {
        String uid = KatelloUtils.getUniqueID();
        String name = "env-" + uid;
        KatelloEnvironment env = new KatelloEnvironment(name, null, this.organization, "Library");
        SSHCommandResult res = env.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully created environment [ %s ]", name)), (String)"Check - returned output string (environment create)");
        res = env.cli_info();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        String descr = "Updating environment";
        res = env.cli_update(descr);
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully updated environment [ %s ]", name)), (String)"Check - returned output string (environment update)");
        res = env.cli_info();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
    }
}

