/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.base.obj;

import com.redhat.qe.katello.base.obj._KatelloObject;
import com.redhat.qe.tools.SSHCommandResult;
import javax.management.Attribute;

public class KatelloSystemGroup
extends _KatelloObject {
    public String name;
    public String org;
    public String description;
    public int totalSystems = 0;
    public Integer maxSystems;
    public static final String CMD_CREATE = "system_group create";
    public static final String CMD_INFO = "system_group info";
    public static final String CMD_LIST = "system_group list";
    public static final String CMD_LIST_SYSTEMS = "system_group systems";
    public static final String CMD_DELETE = "system_group delete";
    public static final String CMD_UPDATE = "system_group update";
    public static final String CMD_COPY = "system_group copy";
    public static final String CMD_ADD_SYSTEMS = "system_group add_systems";
    public static final String CMD_REMOVE_SYSTEMS = "system_group remove_systems";
    public static final String OUT_CREATE = "Successfully created system group [ %s ]";
    public static final String OUT_COPY = "Successfully copied system group [ %s ] to [ %s ]";
    public static final String OUT_ADD_SYSTEMS = "Successfully added systems to system group [ %s ]";
    public static final String OUT_REMOVE_SYSTEMS = "Successfully removed systems from system group [ %s ]";
    public static final String ERR_SYSTEMGROUP_NOTFOUND = "Could not find system group [ %s ] within organization [ %s ]";
    public static final String ERR_SYSTEMGROUP_EXCEED = "Validation failed: You cannot have more than %s system(s) associated with system group '%s'.";
    public static final String REG_SYSTEMGROUP_INFO = ".*Id\\s*:\\s+\\d+.*Name\\s*:\\s+%s.*Description\\s*:\\s+%s.*Total Systems\\s*:\\s+%s.*";
    public static final String REG_SYSTEMGROUP_LIST = ".*\\s+\\d+.*\\s+%s.*";
    public static final String REG_SYSTEM_LIST = ".*\\s+%s.*\\s+%s.*";

    public KatelloSystemGroup(String pName, String pOrg) {
        this(pName, pOrg, null, null);
    }

    public KatelloSystemGroup(String pName, String pOrg, String pDescription, Integer pmaxSystems) {
        this.name = pName;
        this.org = pOrg;
        this.description = pDescription;
        this.maxSystems = pmaxSystems;
    }

    public SSHCommandResult create() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("description", this.description));
        this.opts.add(new Attribute("max_systems", this.maxSystems));
        return this.run(CMD_CREATE);
    }

    public SSHCommandResult info() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        return this.run(CMD_INFO);
    }

    public SSHCommandResult update(String newname, String newdescr, Integer newmaxSystems) {
        this.opts.clear();
        this.opts.add(new Attribute("new_name", newname));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("description", newdescr));
        this.opts.add(new Attribute("max_systems", newmaxSystems));
        return this.run(CMD_UPDATE);
    }

    public SSHCommandResult copy(String newname, String newdescr, Integer newmaxSystems) {
        this.opts.clear();
        this.opts.add(new Attribute("new_name", newname));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("description", newdescr));
        this.opts.add(new Attribute("max_systems", newmaxSystems));
        return this.run(CMD_COPY);
    }

    public SSHCommandResult add_systems(String system_uuids) {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("system_uuids", system_uuids));
        return this.run(CMD_ADD_SYSTEMS);
    }

    public SSHCommandResult remove_systems(String system_uuids) {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("system_uuids", system_uuids));
        return this.run(CMD_REMOVE_SYSTEMS);
    }

    public SSHCommandResult list() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        return this.run(CMD_LIST);
    }

    public SSHCommandResult list_systems() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        return this.run(CMD_LIST_SYSTEMS);
    }

    public SSHCommandResult delete() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        return this.run(CMD_DELETE);
    }
}

