/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.base.obj;

import com.redhat.qe.katello.base.obj._KatelloObject;
import com.redhat.qe.tools.SSHCommandResult;
import javax.management.Attribute;
import org.codehaus.jackson.annotate.JsonProperty;

public class KatelloProvider
extends _KatelloObject {
    public static final String PROVIDER_REDHAT = "Red Hat";
    public static final String CMD_CREATE = "provider create";
    public static final String CMD_IMPORT_MANIFEST = "provider import_manifest";
    public static final String CLI_CMD_LIST = "provider list -v";
    public static final String CMD_INFO = "provider info";
    public static final String CMD_SYNCHRONIZE = "provider synchronize";
    public static final String CMD_UPDATE = "provider update";
    public static final String CMD_DELETE = "provider delete";
    public static final String CMD_STATUS = "provider status";
    public static final String OUT_CREATE = "Successfully created provider [ %s ]";
    public static final String OUT_DELETE = "Deleted provider [ %s ]";
    public static final String OUT_SYNCHRONIZE = "Provider [ %s ] synchronized";
    public static final String ERR_REDHAT_UPDATENAME = "Validation failed: the following attributes can not be updated for the Red Hat provider: [ name ]";
    public static final String OUT_UPDATE = "Successfully updated provider [ %s ]";
    public static final String API_CMD_LIST = "/organizations/%s/providers";
    public static final String MANIFEST_12SUBSCRIPTIONS = "manifest-automation-CLI-12subscriptions.zip";
    public String name;
    public String org;
    public String description;
    public String url;
    private Long id;
    private Long organizationId;
    private String providerType;
    private String updatedAt;

    public KatelloProvider() {
    }

    public KatelloProvider(String pName, String pOrg, String pDesc, String pUrl) {
        this.name = pName;
        this.org = pOrg;
        this.description = pDesc;
        this.url = pUrl;
    }

    public KatelloProvider(Long id, String name, String org, String desc, String url, Long organizationId, String providerType, String updatedAt) {
        this(name, org, desc, url);
        this.id = id;
        this.organizationId = organizationId;
        this.providerType = providerType;
        this.updatedAt = updatedAt;
    }

    public String getName() {
        return this.name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="organization_id")
    public Long getOrganizationId() {
        return this.organizationId;
    }

    @JsonProperty(value="organization_id")
    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    @JsonProperty(value="provider_type")
    public String getProviderType() {
        return this.providerType;
    }

    @JsonProperty(value="provider_type")
    public void setProviderType(String providerType) {
        this.providerType = providerType;
    }

    @JsonProperty(value="updated_at")
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updated_at")
    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    @JsonProperty(value="repository_url")
    public String getRepositoryUrl() {
        return this.url;
    }

    @JsonProperty(value="repository_url")
    public void setRepositoryUrl(String url) {
        this.url = url;
    }

    public SSHCommandResult create() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("description", this.description));
        this.opts.add(new Attribute("url", this.url));
        return this.run(CMD_CREATE);
    }

    public SSHCommandResult import_manifest(String file, Boolean force) {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("file", file));
        this.opts.add(new Attribute("force", ""));
        return this.run(CMD_IMPORT_MANIFEST);
    }

    public SSHCommandResult cli_list() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        return this.run(CLI_CMD_LIST);
    }

    public SSHCommandResult info() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        return this.run(CMD_INFO);
    }

    public SSHCommandResult synchronize() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        return this.run(CMD_SYNCHRONIZE);
    }

    public SSHCommandResult update(String new_name, String url, String description) {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("new_name", new_name));
        this.opts.add(new Attribute("url", url));
        this.opts.add(new Attribute("description", description));
        return this.run(CMD_UPDATE);
    }

    public SSHCommandResult delete() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        return this.run(CMD_DELETE);
    }

    public SSHCommandResult status() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        return this.run(CMD_STATUS);
    }
}

