/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.guice;

import com.google.inject.Provides;
import com.google.inject.name.Named;
import com.redhat.qe.katello.guice.ClientFactoryModule;
import java.lang.annotation.Annotation;
import java.security.SecureRandom;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.HttpContext;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.jboss.resteasy.spi.interception.ClientExecutionInterceptor;

public class PlainModule
extends ClientFactoryModule {
    public PlainModule(Class<? extends Annotation> annotation) {
        super(annotation);
    }

    @Provides
    SSLContext provideSSLContext(TrustManager[] trustManagers, SecureRandom secureRandom) {
        SSLContext clientContext = null;
        try {
            clientContext = SSLContext.getInstance("TLS");
            clientContext.init(null, trustManagers, secureRandom);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return clientContext;
    }

    @Provides
    ClientExecutor provideClientExecutor(HttpClient httpClient, HttpContext context, AuthCache authCache, @Named(value="katello.server.hostname") String hostname, @Named(value="katello.server.port") int port, @Named(value="katello.api.user") String username, @Named(value="katello.api.password") String password) {
        ApacheHttpClient4Executor executor = new ApacheHttpClient4Executor(httpClient, context);
        HttpHost targetHost = new HttpHost(hostname, port, "https");
        ((DefaultHttpClient)httpClient).getCredentialsProvider().setCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()), (Credentials)new UsernamePasswordCredentials(username, password));
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(targetHost, (AuthScheme)basicAuth);
        executor.getHttpContext().setAttribute("http.auth.auth-cache", (Object)authCache);
        return executor;
    }

    @Provides
    List<ClientExecutionInterceptor> provideClientExecutionInterceptors() {
        LinkedList<ClientExecutionInterceptor> interceptors = new LinkedList<ClientExecutionInterceptor>();
        return interceptors;
    }
}

