/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.resteasy.interceptors;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.redhat.qe.katello.ssl.KatelloPemThreadLocal;
import com.redhat.qe.katello.ssl.PEMx509KeyManager;
import java.util.logging.Logger;
import javax.ws.rs.ext.Provider;
import org.apache.http.client.AuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.jboss.resteasy.annotations.interception.ClientInterceptor;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.jboss.resteasy.spi.interception.ClientExecutionContext;
import org.jboss.resteasy.spi.interception.ClientExecutionInterceptor;

@Provider
@ClientInterceptor
public class KatelloClientExecutionInterceptor
implements ClientExecutionInterceptor {
    private final PEMx509KeyManager keyManager;
    private final AuthCache authCache;
    private final String username;
    private final String password;
    private final String hostname;
    private final int port;
    @Inject
    protected Logger log;
    private String pem = null;

    @Inject
    KatelloClientExecutionInterceptor(PEMx509KeyManager[] keyManagers, AuthCache authCache, @Named(value="katello.api.user") String username, @Named(value="katello.api.password") String password, @Named(value="katello.server.hostname") String hostname, @Named(value="katello.server.port") int port) {
        this.keyManager = keyManagers[0];
        this.authCache = authCache;
        this.username = username;
        this.password = password;
        this.hostname = hostname;
        this.port = port;
    }

    public ClientResponse<?> execute(ClientExecutionContext ctx) throws Exception {
        ApacheHttpClient4Executor executor = (ApacheHttpClient4Executor)ctx.getRequest().getExecutor();
        DefaultHttpClient client = (DefaultHttpClient)executor.getHttpClient();
        if (this.pem == null) {
            this.pem = KatelloPemThreadLocal.get();
            if (this.pem != null) {
                this.log.fine("Cert is: \n" + this.pem);
                int endOfFirstPart = this.pem.indexOf("\n", this.pem.indexOf("END"));
                if (endOfFirstPart == -1) {
                    throw new IllegalArgumentException("unable to parse PEM data");
                }
                String certificate = this.pem.substring(0, endOfFirstPart);
                String privateKey = this.pem.substring(endOfFirstPart);
                if (!certificate.startsWith("-----BEGIN CERTIFICATE-----")) {
                    String tmp = privateKey;
                    privateKey = certificate;
                    certificate = tmp;
                }
                this.keyManager.addPEM(certificate, privateKey);
            }
        }
        if (this.pem != null) {
            executor.getHttpContext().removeAttribute("http.auth.auth-cache");
            client.getCredentialsProvider().clear();
        }
        return ctx.proceed();
    }
}

