/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.base.obj;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloCli;
import com.redhat.qe.katello.base.KatelloCliTestScript;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.ArrayList;
import java.util.List;
import javax.management.Attribute;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown=true)
public class KatelloUser {
    public static final String DEFAULT_ADMIN_USER = "admin";
    public static final String DEFAULT_ADMIN_PASS = "admin";
    public static final String DEFAULT_USER_PASS = "testing";
    public static final String DEFAULT_USER_EMAIL = "root@localhost";
    public static final String CMD_CREATE = "user create";
    public static final String CLI_CMD_INFO = "user info";
    public static final String CLI_CMD_LIST = "user list";
    public static final String CMD_ASSIGN_ROLE = "user assign_role";
    public static final String CMD_DELETE_USER = "user delete";
    public static final String CMD_UNASSIGN_ROLE = "user unassign_role";
    public static final String CMD_LIST_ROLES = "user list_roles";
    public static final String CMD_REPORT = "user report";
    public static final String ERR_TEMPLATE_NOTFOUND = "Could not find template [ %s ]";
    public static final String OUT_CREATE = "Successfully created user [ %s ]";
    public static final String OUT_DELETE = "Successfully deleted user [ %s ]";
    public static final String OUT_ASSIGN_ROLE = "User '%s' assigned to role '%s'";
    public static final String OUT_UNASSIGN_ROLE = "User '%s' unassigned from role '%s'";
    public static final String OUT_FIND_USER_ERROR = "Could not find user [ %s ]";
    public static final String REG_USER_LIST = ".*Id:\\s+\\d+.*Username:\\s+%s.*Email:\\s+%s.*";
    public static final String REG_USER_ROLE_LIST = ".*\\d+\\s+%s.*";
    public static final String API_CMD_INFO = "/users/%s";
    public static final String API_CMD_LIST = "/users";
    public static final String API_CMD_CREATE = "/users";
    public String username;
    public String email;
    public String password;
    public boolean disabled;
    public String orgname = "";
    public String envname = "";
    private Long id;
    private KatelloCli cli;
    private List<Attribute> opts;

    public KatelloUser() {
    }

    public KatelloUser(String pName, String pEmail, String pPassword, boolean pDisabled) {
        this.username = pName;
        this.email = pEmail;
        this.password = pPassword;
        this.disabled = pDisabled;
        this.opts = new ArrayList<Attribute>();
    }

    public KatelloUser(String pName, String pEmail, String pPassword, boolean pDisabled, String pOrgname, String pEnvname) {
        this.username = pName;
        this.email = pEmail;
        this.password = pPassword;
        this.disabled = pDisabled;
        this.orgname = pOrgname;
        this.envname = pEnvname;
        this.opts = new ArrayList<Attribute>();
    }

    public KatelloUser(String pName, String pEmail, String pPassword, boolean pDisabled, String pOrgname, String pEnvname, Long id) {
        this(pName, pEmail, pPassword, pDisabled, pOrgname, pEnvname);
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public static final SSHCommandResult report(String format) {
        ArrayList<Attribute> opts = new ArrayList<Attribute>();
        opts.clear();
        if (!format.isEmpty()) {
            opts.add(new Attribute("format", format));
        }
        KatelloCli cli = new KatelloCli(CMD_REPORT, opts);
        return cli.run();
    }

    public SSHCommandResult cli_create() {
        this.opts.clear();
        this.opts.add(new Attribute("username", this.username));
        this.opts.add(new Attribute("password", this.password));
        this.opts.add(new Attribute("email", this.email));
        if (this.disabled) {
            this.opts.add(new Attribute("disabled", "true"));
        }
        if (!this.orgname.isEmpty()) {
            this.opts.add(new Attribute("default_organization", this.orgname));
        }
        if (!this.envname.isEmpty()) {
            this.opts.add(new Attribute("default_environment", this.envname));
        }
        this.cli = new KatelloCli(CMD_CREATE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult cli_info() {
        this.opts.clear();
        this.opts.add(new Attribute("username", this.username));
        this.cli = new KatelloCli(CLI_CMD_INFO, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult cli_list() {
        this.opts.clear();
        this.cli = new KatelloCli("user list -v", this.opts);
        return this.cli.run();
    }

    public SSHCommandResult assign_role(String role) {
        this.opts.clear();
        this.opts.add(new Attribute("username", this.username));
        this.opts.add(new Attribute("role", role));
        this.cli = new KatelloCli(CMD_ASSIGN_ROLE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult unassign_role(String role) {
        this.opts.clear();
        this.opts.add(new Attribute("username", this.username));
        this.opts.add(new Attribute("role", role));
        this.cli = new KatelloCli(CMD_UNASSIGN_ROLE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult list_roles() {
        this.opts.clear();
        this.opts.add(new Attribute("username", this.username));
        this.cli = new KatelloCli(CMD_LIST_ROLES, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult delete() {
        this.opts.clear();
        this.opts.add(new Attribute("username", this.username));
        this.cli = new KatelloCli(CMD_DELETE_USER, this.opts);
        return this.cli.run();
    }

    public void asserts_delete() {
        SSHCommandResult res = this.cli_list();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (user list)");
    }

    public void asserts_create() {
        SSHCommandResult res = this.cli_list();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (user list)");
        String REGEXP_LIST = ".*Id:\\s+\\d+.*Username:\\s+%s.*Email:\\s+%s.*Disabled:\\s+False.*Default Organization:\\s+%s.*Default Environment:\\s+%s.*";
        if (this.disabled) {
            REGEXP_LIST = ".*Id:\\s+\\d+.*Username:\\s+%s.*Email:\\s+%s.*Disabled:\\s+True.*Default Organization:\\s+%s.*Default Environment:\\s+%s.*";
        }
        String match_info = String.format(REGEXP_LIST, this.username, this.email, this.orgname != null ? this.orgname : "None", this.envname != null ? this.envname : "None").replaceAll("\"", "");
        Assert.assertTrue((boolean)KatelloCliTestScript.sgetOutput(res).replaceAll("\n", "").matches(match_info), (String)String.format("User [%s] should be found in the list", this.username));
        res = this.cli_info();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (user info)");
        String REGEXP_INFO = ".*Id:\\s+\\d+.*Username:\\s+%s.*Email:\\s+%s.*Disabled:\\s+False.*Default Organization:\\s+%s.*Default Environment:\\s+%s.*";
        if (this.disabled) {
            REGEXP_INFO = ".*Id:\\s+\\d+.*Username:\\s+%s.*Email:\\s+%s.*Disabled:\\s+True.*Default Organization:\\s+%s.*Default Environment:\\s+%s.*";
        }
        match_info = String.format(REGEXP_INFO, this.username, this.email, this.orgname != null ? this.orgname : "None", this.envname != null ? this.envname : "None").replaceAll("\"", "");
        Assert.assertTrue((boolean)KatelloCliTestScript.sgetOutput(res).replaceAll("\n", "").matches(match_info), (String)String.format("User [%s] should contain correct info", this.username));
    }
}

