/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.api;

import com.google.inject.Inject;
import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloApiException;
import com.redhat.qe.katello.base.KatelloTestScript;
import com.redhat.qe.katello.base.obj.KatelloEntitlement;
import com.redhat.qe.katello.base.obj.KatelloEnvironment;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.base.obj.KatelloPool;
import com.redhat.qe.katello.base.obj.KatelloSystem;
import com.redhat.qe.katello.common.KatelloUtils;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"cfse-api"})
public class ConsumersTest
extends KatelloTestScript {
    @Inject
    Logger log;
    private String consumer_id = null;
    private String consumer_name = null;
    private String env_name = null;
    private String org_name = null;

    @BeforeClass(description="Prepare an organization to work with")
    public void setUp_createOrg() throws KatelloApiException {
        String uid = KatelloUtils.getUniqueID();
        this.org_name = "auto-org-" + uid;
        String org_descr = "Test Organization " + uid;
        KatelloOrg org = this.servertasks.createOrganization(this.org_name, org_descr);
        uid = KatelloUtils.getUniqueID();
        this.env_name = "auto-env-" + uid;
        String env_descr = "Test Environment " + uid;
        this.servertasks.createEnvironment(org.getCpKey(), this.env_name, env_descr, "Library");
    }

    @Test(groups={"testConsumers"}, description="Create consumer")
    public void test_createConsumer() {
        String pid = KatelloUtils.getUniqueID();
        this.consumer_name = "auto-" + pid + ".yourorg.com";
        String uuid = KatelloUtils.getUUID();
        KatelloSystem consumer = null;
        try {
            consumer = this.servertasks.createConsumer(this.org_name, this.consumer_name, uuid);
        }
        catch (KatelloApiException e) {
            Assert.fail((String)"Could not create consumer", (Throwable)e);
        }
        this.consumer_id = consumer.getUuid();
        Assert.assertNotNull((Object)this.consumer_id, (String)"Check returned: uuid");
        Assert.assertEquals((String)consumer.getName(), (String)this.consumer_name, (String)"Check returned: name");
        this.log.info("Prepared a consumer: [" + this.consumer_id + "]");
    }

    @Test(groups={"testConsumers"}, description="Retrieve consumer", dependsOnMethods={"test_createConsumer"})
    public void test_getConsumer() {
        KatelloSystem consumer = null;
        try {
            consumer = this.servertasks.getConsumer(this.consumer_id);
        }
        catch (KatelloApiException e) {
            Assert.fail((String)"Get customer failed", (Throwable)e);
        }
        Assert.assertEquals((String)this.consumer_id, (String)consumer.getUuid(), (String)"Check returned: uuid");
        KatelloEnvironment environment = this.servertasks.getEnvironment(this.org_name, this.env_name);
        Assert.assertEquals((Object)consumer.getEnvironmentId(), (Object)environment.getId(), (String)"Check returned: environment_id");
        Assert.assertEquals((String)this.org_name, (String)consumer.getOwner().getDisplayName(), (String)"Check returned: owner.displayName");
        Assert.assertEquals((String)("/consumers/" + this.consumer_id), (String)consumer.getHref(), (String)"Check returned: href");
        Assert.assertEquals((String)this.consumer_name, (String)consumer.getName(), (String)"Check returned: name");
        Assert.assertEquals((String)this.consumer_name, (String)consumer.getFacts().get("network.hostname"), (String)"Check returned: facts.network.hostname");
        Assert.assertNotNull((Object)consumer.getIdCert().getId(), (String)"Check returned: idCert.id");
    }

    @Test(groups={"testConsumers"}, description="Update consumer details", dependsOnMethods={"test_createConsumer"})
    public void test_updateConsumer() {
        String upd_component = "uname.release";
        String upd_value = "2.6.32-130.el6.i386";
        try {
            this.servertasks.updateFacts(this.consumer_id, upd_component, upd_value);
            Map<String, String> newFacts = this.servertasks.getConsumer(this.consumer_id).getFacts();
            Assert.assertEquals((String)upd_value, (String)newFacts.get(upd_component), (String)("Check updated: facts." + upd_component));
        }
        catch (KatelloApiException e) {
            Assert.fail((String)"Update consumer failed", (Throwable)e);
        }
    }

    @Test(groups={"testConsumers"}, description="Delete consumer", enabled=true)
    public void test_deleteConsumer() {
        String pid = KatelloUtils.getUniqueID();
        String cname = "auto-" + pid + ".delete.me";
        String uuid = KatelloUtils.getUUID();
        KatelloSystem consumer = null;
        try {
            consumer = this.servertasks.createConsumer(this.org_name, cname, uuid);
        }
        catch (KatelloApiException e) {
            Assert.fail((String)"Could not create consumer", (Throwable)e);
        }
        String cid = consumer.getUuid();
        String ret = null;
        try {
            ret = this.servertasks.deleteConsumer(cid);
        }
        catch (KatelloApiException e) {
            Assert.fail((String)"Could not delete consumer", (Throwable)e);
        }
        Assert.assertTrue((ret == null || ret.trim().isEmpty() ? 1 : 0) != 0, (String)"Check returned string (empty)");
        try {
            this.servertasks.getConsumer(cid);
        }
        catch (KatelloApiException e) {
            Assert.assertTrue((e.getReturnCode() == 410 ? 1 : 0) != 0, (String)("Check API request to get consumer: [" + cid + "]"));
        }
    }

    @Test(groups={"testConsumers", "rhsm-related"}, description="Import export.zip manifest", enabled=false)
    public void test_importManifest() {
        String pid = KatelloUtils.getUniqueID();
        String prov_MF = "ExpMan_" + pid;
        this.log.info("Check if there was another import of export.zip before.");
        try {
            if (this.servertasks.getProductByOrg(this.org_name, "Awesome OS Server Basic") == null) {
                Long provider_id = this.servertasks.getProvider(this.org_name, prov_MF).getId();
                int prods_before = this.servertasks.getProductsByOrg(this.org_name).size();
                String ret = this.servertasks.uploadManifest(provider_id, EXPORT_ZIP_PATH);
                int prods_after = this.servertasks.getProductsByOrg(this.org_name).size();
                Assert.assertEquals((String)ret, (String)"Manifest imported", (String)"Output should be: \"Manifest imported\"");
                Assert.assertTrue((prods_after - prods_before >= 6 ? 1 : 0) != 0, (String)"Check imported products: >=[6]");
            } else {
                this.log.warning("Skip running of the test: test_importManifest. Cleanup DBs for this test run.");
            }
        }
        catch (KatelloApiException e) {
            Assert.fail((String)"API call failed", (Throwable)e);
        }
    }

    @Test(dependsOnMethods={"test_createConsumer", "test_importManifest"}, description="Subscribe consumer system to a pool", enabled=false)
    public void test_subscribeConsumer() {
        String pool_id = null;
        try {
            pool_id = this.servertasks.getPool("Awesome OS Server Basic");
        }
        catch (KatelloApiException e1) {
            e1.printStackTrace();
        }
        List<KatelloEntitlement> entitlements = null;
        try {
            entitlements = this.servertasks.subscribeConsumer(this.consumer_id, pool_id);
        }
        catch (KatelloApiException e) {
            Assert.fail((String)"Could not subscribe consumer", (Throwable)e);
        }
        KatelloEntitlement entitlement = entitlements.get(0);
        String entitlement_id = entitlement.getId();
        String certificate_id = entitlement.getCertificates().get(0).getId();
        Assert.assertEquals((String)entitlement.getPool().getId(), (String)pool_id, (String)"Check returned pool id");
        Assert.assertNotNull((Object)entitlement_id, (String)"Check returned entitlement id");
        Assert.assertNotNull((Object)certificate_id, (String)"Check returned certificate id");
    }

    @Test(dependsOnMethods={"test_subscribeConsumer"}, description="Re-subscribe consumer system to a pool", enabled=false)
    public void test_resubscribeToPool() {
        String pool_id = null;
        try {
            pool_id = this.servertasks.getPool("Awesome OS Server Basic");
        }
        catch (KatelloApiException e1) {
            e1.printStackTrace();
        }
        try {
            this.servertasks.subscribeConsumer(this.consumer_id, pool_id);
        }
        catch (KatelloApiException e) {
            Assert.assertEquals((String)e.getMessage(), (String)("{\"displayMessage\":\"This consumer is already subscribed to the product matching pool with id '" + pool_id + "'\"}"));
        }
    }

    @Test(description="Unsubscribe consumer from the pool just subscribed", enabled=false)
    public void test_unsubscribeConsumer() {
        String pid = KatelloUtils.getUniqueID();
        String cname = "auto-" + pid + ".unsubscribed";
        String uuid = KatelloUtils.getUUID();
        KatelloSystem consumer = null;
        try {
            consumer = this.servertasks.createConsumer(this.org_name, cname, uuid);
        }
        catch (KatelloApiException e) {
            Assert.fail((String)"Could not create consumer", (Throwable)e);
        }
        String cid = consumer.getUuid();
        String pool_id = null;
        try {
            pool_id = this.servertasks.getPool("Awesome OS Server Basic");
        }
        catch (KatelloApiException e1) {
            e1.printStackTrace();
        }
        List<Long> serials = null;
        try {
            this.servertasks.subscribeConsumer(cid, pool_id);
            serials = this.servertasks.getSerials(cid);
        }
        catch (KatelloApiException e) {
            Assert.fail((String)"API operation failed", (Throwable)e);
        }
        Assert.assertMore((Comparable)Integer.valueOf(serials.size()), (Comparable)Integer.valueOf(0), (String)"Serials count: >0");
        Long serial_id1 = serials.get(0);
        try {
            this.servertasks.unsubscribeConsumer(cid, serial_id1.toString());
        }
        catch (KatelloApiException e) {
            Assert.fail((String)"Could not unsubscribe consumer", (Throwable)e);
        }
        try {
            serials = this.servertasks.getSerials(cid);
        }
        catch (KatelloApiException e) {
            Assert.fail((String)"Could not get serials", (Throwable)e);
        }
        Assert.assertEquals((int)serials.size(), (int)0, (String)"Check no serials available: no subscriptions");
    }

    @Test(description="Unsubscribe consumer from the all pools being subscribed", enabled=false)
    public void test_unsubscribeConsumerAll() {
        String cname = "auto-" + KatelloUtils.getUniqueID() + ".unsubscribe.all";
        KatelloSystem consumer = null;
        try {
            consumer = this.servertasks.createConsumer(this.org_name, cname, KatelloUtils.getUUID());
        }
        catch (KatelloApiException e) {
            Assert.fail((String)"Could not create consumer", (Throwable)e);
        }
        String consumer_id = consumer.getUuid();
        List<KatelloPool> pools = null;
        try {
            pools = this.servertasks.getPools();
        }
        catch (KatelloApiException e1) {
            e1.printStackTrace();
        }
        for (KatelloPool pool : pools) {
            if (!pool.getOwner().getDisplayName().equals(this.org_name)) continue;
            try {
                this.servertasks.subscribeConsumer(consumer_id, pool.getId());
            }
            catch (KatelloApiException ex) {}
        }
        List<Long> serials = null;
        try {
            serials = this.servertasks.getSerials(consumer_id);
        }
        catch (KatelloApiException e) {
            Assert.fail((String)"Could not get serials", (Throwable)e);
        }
        Assert.assertMore((Comparable)Integer.valueOf(serials.size()), (Comparable)Integer.valueOf(1), (String)"Check: subscriptions should be >1");
        try {
            this.servertasks.unsubscribeConsumer(consumer_id);
        }
        catch (KatelloApiException e) {
            Assert.fail((String)"Could not unsubscribe consumer", (Throwable)e);
        }
        try {
            serials = this.servertasks.getSerials(consumer_id);
        }
        catch (KatelloApiException e) {
            Assert.fail((String)"Could not get serials", (Throwable)e);
        }
        Assert.assertEquals((int)serials.size(), (int)0, (String)"Check: subscriptions should be ==0");
    }
}

