/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.guice;

import com.google.inject.Binder;
import com.google.inject.PrivateModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.redhat.qe.auto.testng.TestScript;
import com.redhat.qe.katello.resource.ConsumerResource;
import com.redhat.qe.katello.resource.OrganizationResource;
import com.redhat.qe.katello.resource.PoolResource;
import com.redhat.qe.katello.resource.ProviderResource;
import com.redhat.qe.katello.resource.RepositoryResource;
import com.redhat.qe.katello.resource.SystemResource;
import com.redhat.qe.katello.resource.UserResource;
import com.redhat.qe.katello.resteasy.interceptors.KatelloClientExecutionInterceptor;
import com.redhat.qe.katello.ssl.PEMx509KeyManager;
import com.redhat.qe.katello.tasks.KatelloTasks;
import com.redhat.qe.katello.tasks.impl.KatelloApiTasks;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.AuthCache;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.BasicClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequestFactory;
import org.jboss.resteasy.client.core.ClientInterceptorRepositoryImpl;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;

public abstract class ClientFactoryModule
extends PrivateModule {
    private final Class<? extends Annotation> annotation;

    ClientFactoryModule(Class<? extends Annotation> annotation) {
        this.annotation = annotation;
    }

    protected void configure() {
        this.bind(AuthCache.class).to(BasicAuthCache.class);
        this.bind(HttpParams.class).to(BasicHttpParams.class);
        this.bind(HttpContext.class).to(BasicHttpContext.class);
        TestScript.loadProperties();
        Names.bindProperties((Binder)this.binder(), (Properties)System.getProperties());
        this.bindSSLContext();
        this.bind(KatelloTasks.class).annotatedWith(this.annotation).to(KatelloApiTasks.class);
        this.expose(KatelloTasks.class).annotatedWith(this.annotation);
    }

    abstract void bindSSLContext();

    @Provides
    @Named(value="katello.url")
    String provideKatelloUrl(@Named(value="katello.server.protocol") String protocol, @Named(value="katello.server.hostname") String hostname, @Named(value="katello.server.port") int port, @Named(value="katello.product") String product) {
        return String.format("%s://%s:%d/%s/api", protocol, hostname, port, product);
    }

    @Provides
    OrganizationResource provideOrganizationResource(ClientRequestFactory clientRequestFactory) {
        return (OrganizationResource)clientRequestFactory.createProxy(OrganizationResource.class);
    }

    @Provides
    RepositoryResource provideRepositoryResource(ClientRequestFactory clientRequestFactory) {
        return (RepositoryResource)clientRequestFactory.createProxy(RepositoryResource.class);
    }

    @Provides
    ConsumerResource provideConsumerResource(ClientRequestFactory clientRequestFactory) {
        return (ConsumerResource)clientRequestFactory.createProxy(ConsumerResource.class);
    }

    @Provides
    UserResource provideUserResource(ClientRequestFactory clientRequestFactory) {
        return (UserResource)clientRequestFactory.createProxy(UserResource.class);
    }

    @Provides
    PoolResource providePoolResource(ClientRequestFactory clientRequestFactory) {
        return (PoolResource)clientRequestFactory.createProxy(PoolResource.class);
    }

    @Provides
    SystemResource provideSystemResource(ClientRequestFactory clientRequestFactory) {
        return (SystemResource)clientRequestFactory.createProxy(SystemResource.class);
    }

    @Provides
    ProviderResource provideProviderResource(ClientRequestFactory clientRequestFactory) {
        return (ProviderResource)clientRequestFactory.createProxy(ProviderResource.class);
    }

    @Provides
    @Singleton
    PEMx509KeyManager[] provideKeyManagers() {
        System.out.println("provideKeyManagers");
        PEMx509KeyManager[] managers = new PEMx509KeyManager[]{new PEMx509KeyManager()};
        return managers;
    }

    @Provides
    @Singleton
    TrustManager[] provideTrustManagers() {
        System.out.println("provideTrustManagers");
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                System.out.println("getAcceptedIssuers");
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                System.out.println("checkClientTrusted");
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                System.out.println("checkServerTrusted");
            }
        }};
    }

    @Provides
    SSLSocketFactory provideSSLSocketFactory(SSLContext sslContext) throws Exception {
        System.out.println("provideSSLSocketFactory");
        return new SSLSocketFactory(sslContext);
    }

    @Provides
    SchemeRegistry provideSchemeRegistry(SSLSocketFactory sslSocketFactory) {
        System.out.println("provideSchemeRegistry");
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        try {
            Scheme httpsScheme = new Scheme("https", 443, (SchemeSocketFactory)sslSocketFactory);
            schemeRegistry.register(httpsScheme);
        }
        catch (Exception e) {
            System.err.println("HttpClient: Scheme not initialized properly");
            e.printStackTrace();
        }
        return schemeRegistry;
    }

    @Provides
    ClientConnectionManager provideClientConnectionManager(SchemeRegistry schemeRegistry) {
        System.out.println("provideClientConnectionManager");
        BasicClientConnectionManager cm = new BasicClientConnectionManager(schemeRegistry);
        return cm;
    }

    @Provides
    HttpClient provideHttpClient(ClientConnectionManager clientConnectionManager, HttpParams params) {
        System.out.println("provideHttpClient");
        DefaultHttpClient httpClient = new DefaultHttpClient(clientConnectionManager, params);
        httpClient.addResponseInterceptor(new HttpResponseInterceptor(){

            public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
                if (response.getStatusLine().getStatusCode() == 401 && !response.containsHeader("WWW-Authenticate")) {
                    response.addHeader("WWW-Authenticate", "realm='Basic security'");
                }
            }
        });
        return httpClient;
    }

    @Provides
    ClientExecutor provideClientExecutor(HttpClient httpClient, HttpContext context) {
        System.out.println("provideClientExecutor");
        ApacheHttpClient4Executor executor = new ApacheHttpClient4Executor(httpClient, context);
        return executor;
    }

    @Provides
    @Singleton
    ClientRequestFactory provideClientRequestFactory(ClientExecutor clientExecutor, KatelloClientExecutionInterceptor katelloClientExecutionInterceptor, @Named(value="katello.url") String url) {
        System.out.println("provideClientRequestFactory");
        ClientRequestFactory clientRequestFactory = null;
        try {
            clientRequestFactory = new ClientRequestFactory(clientExecutor, new URI(url));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        ClientInterceptorRepositoryImpl interceptors = clientRequestFactory.getPrefixInterceptors();
        interceptors.registerInterceptor((Object)katelloClientExecutionInterceptor);
        return clientRequestFactory;
    }
}

