/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.redhat.qe.auto.testng.TestScript;
import com.redhat.qe.katello.resource.ConsumerResource;
import com.redhat.qe.katello.resource.OrganizationResource;
import com.redhat.qe.katello.resource.PoolResource;
import com.redhat.qe.katello.resource.ProviderResource;
import com.redhat.qe.katello.resource.RepositoryResource;
import com.redhat.qe.katello.resource.SystemResource;
import com.redhat.qe.katello.resource.UserResource;
import com.redhat.qe.katello.resteasy.interceptors.KatelloClientExecutionInterceptor;
import com.redhat.qe.katello.ssl.SSLContextProviderFactory;
import com.redhat.qe.katello.tasks.KatelloTasks;
import com.redhat.qe.katello.tasks.impl.KatelloApiTasks;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.logging.Logger;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequestFactory;
import org.jboss.resteasy.client.core.ClientInterceptorRepositoryImpl;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;

public class KatelloApiModule
extends AbstractModule {
    @Inject
    Logger log;

    protected void configure() {
        this.bind(AuthCache.class).to(BasicAuthCache.class);
        this.install(new FactoryModuleBuilder().build(SSLContextProviderFactory.class));
        this.bind(KatelloTasks.class).to(KatelloApiTasks.class).in(Singleton.class);
        TestScript.loadProperties();
        Names.bindProperties((Binder)this.binder(), (Properties)System.getProperties());
    }

    @Provides
    @Named(value="katello.url")
    String provideKatelloUrl(@Named(value="katello.server.protocol") String protocol, @Named(value="katello.server.hostname") String hostname, @Named(value="katello.server.port") int port, @Named(value="katello.product") String product) {
        return String.format("%s://%s:%d/%s/api", protocol, hostname, port, product);
    }

    @Provides
    OrganizationResource provideOrganizationResource(ClientRequestFactory clientRequestFactory) {
        return (OrganizationResource)clientRequestFactory.createProxy(OrganizationResource.class);
    }

    @Provides
    RepositoryResource provideRepositoryResource(ClientRequestFactory clientRequestFactory) {
        return (RepositoryResource)clientRequestFactory.createProxy(RepositoryResource.class);
    }

    @Provides
    ConsumerResource provideConsumerResource(ClientRequestFactory clientRequestFactory) {
        return (ConsumerResource)clientRequestFactory.createProxy(ConsumerResource.class);
    }

    @Provides
    UserResource provideUserResource(ClientRequestFactory clientRequestFactory) {
        return (UserResource)clientRequestFactory.createProxy(UserResource.class);
    }

    @Provides
    PoolResource providePoolResource(ClientRequestFactory clientRequestFactory) {
        return (PoolResource)clientRequestFactory.createProxy(PoolResource.class);
    }

    @Provides
    SystemResource provideSystemResource(ClientRequestFactory clientRequestFactory) {
        return (SystemResource)clientRequestFactory.createProxy(SystemResource.class);
    }

    @Provides
    ProviderResource provideProviderResource(ClientRequestFactory clientRequestFactory) {
        return (ProviderResource)clientRequestFactory.createProxy(ProviderResource.class);
    }

    @Provides
    SchemeRegistry provideSchemeRegistry(SSLContextProviderFactory sslContextProviderFactory) {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        try {
            SSLSocketFactory sf = new SSLSocketFactory(sslContextProviderFactory.create().get());
            Scheme httpsScheme = new Scheme("https", 443, (SchemeSocketFactory)sf);
            schemeRegistry.register(httpsScheme);
        }
        catch (Exception e) {
            System.err.println("HttpClient: Scheme not initialized properly");
            e.printStackTrace();
        }
        return schemeRegistry;
    }

    @Provides
    ClientExecutor provideClientExecutor(AuthCache authCache, SchemeRegistry schemeRegistry, @Named(value="katello.api.user") String username, @Named(value="katello.api.password") String password, @Named(value="katello.server.hostname") String hostname, @Named(value="katello.server.port") int port) {
        BasicHttpParams params = new BasicHttpParams();
        PoolingClientConnectionManager cm = new PoolingClientConnectionManager(schemeRegistry);
        cm.setDefaultMaxPerRoute(10);
        HttpHost targetHost = new HttpHost(hostname, port, "https");
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)cm, (HttpParams)params);
        httpClient.getCredentialsProvider().setCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()), (Credentials)new UsernamePasswordCredentials(username, password));
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(targetHost, (AuthScheme)basicAuth);
        BasicHttpContext localcontext = new BasicHttpContext();
        localcontext.setAttribute("http.auth.auth-cache", (Object)authCache);
        return new ApacheHttpClient4Executor((HttpClient)httpClient, (HttpContext)localcontext);
    }

    @Provides
    TrustManager[] provideTrustManagers() {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }
        }};
    }

    @Provides
    @Singleton
    ClientRequestFactory provideClientRequestFactory(ClientExecutor clientExecutor, KatelloClientExecutionInterceptor katelloClientExecutionInterceptor, @Named(value="katello.url") String url) {
        ClientRequestFactory clientRequestFactory = null;
        try {
            clientRequestFactory = new ClientRequestFactory(clientExecutor, new URI(url));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        ClientInterceptorRepositoryImpl interceptors = clientRequestFactory.getPrefixInterceptors();
        interceptors.registerInterceptor((Object)katelloClientExecutionInterceptor);
        return clientRequestFactory;
    }
}

