/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.base;

import com.google.inject.Inject;
import com.redhat.qe.auto.testng.TestScript;
import com.redhat.qe.katello.base.KatelloApiException;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.common.KatelloConstants;
import com.redhat.qe.katello.guice.KatelloApiModule;
import com.redhat.qe.katello.tasks.KatelloTasks;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.testng.annotations.Guice;

@Guice(modules={KatelloApiModule.class})
public abstract class KatelloTestScript
extends TestScript
implements KatelloConstants {
    @Inject
    protected Logger log;
    @Inject
    protected KatelloTasks servertasks = null;
    private SimpleDateFormat dateFormatter = null;
    private static String default_org = null;

    public KatelloTestScript() {
        try {
            this.dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Date parseKatelloDate(String strDate) throws ParseException {
        String sDate = strDate.substring(0, 19);
        return this.dateFormatter.parse(sDate);
    }

    public String getDefaultOrg() throws KatelloApiException {
        if (default_org == null) {
            List<KatelloOrg> orgs = this.servertasks.getOrganizations();
            for (KatelloOrg org : orgs) {
                if (org.getId() != 1L) continue;
                default_org = org.getName();
            }
        }
        return default_org;
    }
}

