/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.resteasy.interceptors;

import com.google.inject.Inject;
import com.redhat.qe.katello.ssl.SSLContextProviderFactory;
import java.util.logging.Logger;
import javax.ws.rs.ext.Provider;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.protocol.BasicHttpContext;
import org.jboss.resteasy.annotations.interception.ClientInterceptor;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.jboss.resteasy.spi.interception.ClientExecutionContext;
import org.jboss.resteasy.spi.interception.ClientExecutionInterceptor;

@Provider
@ClientInterceptor
public class KatelloClientExecutionInterceptor
implements ClientExecutionInterceptor {
    private final SSLContextProviderFactory sslContextProviderFactory;
    @Inject
    protected Logger log;

    @Inject
    public KatelloClientExecutionInterceptor(SSLContextProviderFactory sslContextProviderFactory) {
        this.sslContextProviderFactory = sslContextProviderFactory;
    }

    public ClientResponse<?> execute(ClientExecutionContext ctx) throws Exception {
        ApacheHttpClient4Executor executor = (ApacheHttpClient4Executor)ctx.getRequest().getExecutor();
        BasicHttpContext context = (BasicHttpContext)executor.getHttpContext();
        String pem = (String)context.getAttribute("pem");
        context.removeAttribute("pem");
        DefaultHttpClient client = (DefaultHttpClient)executor.getHttpClient();
        PoolingClientConnectionManager cm = (PoolingClientConnectionManager)client.getConnectionManager();
        SSLSocketFactory sf = null;
        sf = pem != null ? new SSLSocketFactory(this.sslContextProviderFactory.create(pem).get()) : new SSLSocketFactory(this.sslContextProviderFactory.create().get());
        Scheme httpsScheme = new Scheme("https", 443, (SchemeSocketFactory)sf);
        cm.getSchemeRegistry().register(httpsScheme);
        return ctx.proceed();
    }
}

